/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.ByteString;
import com.mapr.fs.proto.Dbfilters;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.hbase.async.Bytes;
import org.hbase.async.ScanFilter;
import org.hbase.async.generated.ComparatorPB;
import org.hbase.async.generated.FilterPB;
import org.hbase.async.generated.HBasePB;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.util.CharsetUtil;

public final class KeyRegexpFilter
extends ScanFilter {
    private static final byte[] ROWFILTER = Bytes.ISO88591("org.apache.hadoop.hbase.filter.RowFilter");
    private static final byte[] REGEXSTRINGCOMPARATOR = Bytes.ISO88591("org.apache.hadoop.hbase.filter.RegexStringComparator");
    private static final byte[] EQUAL = new byte[]{69, 81, 85, 65, 76};
    private final byte[] regexp;
    private final byte[] bCharset;
    private final Charset charset;
    private static final int kRegexStringComparator = -489178560;
    private static final int kRowFilter = 1184742660;

    public KeyRegexpFilter(String regexp) {
        this(regexp, CharsetUtil.ISO_8859_1);
    }

    public KeyRegexpFilter(String regexp, Charset charset) {
        this(regexp.getBytes(charset), charset);
    }

    public KeyRegexpFilter(byte[] regexp) {
        this(regexp, CharsetUtil.ISO_8859_1);
    }

    public KeyRegexpFilter(byte[] regexp, Charset charset) {
        this.regexp = regexp;
        this.charset = charset;
        this.bCharset = Bytes.UTF8(charset.name());
    }

    public byte[] getRegexp() {
        return Arrays.copyOf(this.regexp, this.regexp.length);
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    byte[] serialize() {
        ComparatorPB.Comparator.Builder comparator = ComparatorPB.Comparator.newBuilder();
        comparator.setNameBytes(Bytes.wrap(REGEXSTRINGCOMPARATOR));
        byte[] regex_cmp = ComparatorPB.RegexStringComparator.newBuilder().setPatternBytes(Bytes.wrap(this.regexp)).setPatternFlags(0).setCharsetBytes(Bytes.wrap(this.bCharset)).build().toByteArray();
        comparator.setSerializedComparator(Bytes.wrap(regex_cmp));
        FilterPB.CompareFilter cmp = FilterPB.CompareFilter.newBuilder().setCompareOp(HBasePB.CompareType.EQUAL).setComparator(comparator.build()).build();
        return FilterPB.RowFilter.newBuilder().setCompareFilter(cmp).build().toByteArray();
    }

    @Override
    byte[] name() {
        return ROWFILTER;
    }

    @Override
    void serializeOld(ChannelBuffer buf) {
        buf.writeByte((int)((byte)ROWFILTER.length));
        buf.writeBytes(ROWFILTER);
        buf.writeShort(5);
        buf.writeBytes(EQUAL);
        buf.writeByte(54);
        buf.writeByte(0);
        buf.writeByte((int)((byte)REGEXSTRINGCOMPARATOR.length));
        buf.writeBytes(REGEXSTRINGCOMPARATOR);
        buf.writeShort(this.regexp.length);
        buf.writeBytes(this.regexp);
        buf.writeShort(this.bCharset.length);
        buf.writeBytes(this.bCharset);
    }

    @Override
    int predictSerializedSize() {
        return 105 + this.regexp.length + 2 + this.bCharset.length;
    }

    public String toString() {
        return "KeyRegexpFilter(\"" + new String(this.regexp, CharsetUtil.UTF_8) + "\", " + this.charset.name() + ')';
    }

    private byte[] getPatternBytes() {
        if (!this.charset.equals(CharsetUtil.ISO_8859_1)) {
            return this.regexp;
        }
        StringBuilder buf = new StringBuilder();
        for (byte b : this.regexp) {
            if (b == 0) {
                buf.append("\\E\\000\\Q");
                continue;
            }
            buf.append((char)(b & 0xFF));
        }
        return buf.toString().getBytes(this.charset);
    }

    @Override
    protected ByteString getState() {
        Dbfilters.RegexStringComparatorProto rcp = Dbfilters.RegexStringComparatorProto.newBuilder().setPattern(ByteString.copyFrom((byte[])this.getPatternBytes())).setIsUTF8(this.charset.equals(CharsetUtil.UTF_8)).build();
        Dbfilters.ComparatorProto cp = Dbfilters.ComparatorProto.newBuilder().setName(KeyRegexpFilter.getFilterId(-489178560)).setSerializedComparator(rcp.toByteString()).build();
        Dbfilters.FilterComparatorProto.Builder fcp = Dbfilters.FilterComparatorProto.newBuilder().setCompareOp(Dbfilters.CompareOpProto.EQUAL).setComparator(cp);
        return Dbfilters.RowFilterProto.newBuilder().setFilterComparator(fcp).build().toByteString();
    }

    @Override
    protected String getId() {
        return KeyRegexpFilter.getFilterId(1184742660);
    }
}

