/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.ByteString;
import com.mapr.fs.proto.Dbfilters;
import java.util.Collection;
import java.util.Collections;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseRpc;
import org.hbase.async.ScanFilter;
import org.hbase.async.generated.FilterPB;
import org.hbase.async.generated.HBasePB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class FuzzyRowFilter
extends ScanFilter {
    private static final byte[] NAME = Bytes.UTF8("org.apache.hadoop.hbase.filter.FuzzyRowFilter");
    private final Collection<FuzzyFilterPair> filter_pairs;
    public static final int kFuzzyRowFilter = -707981514;

    public FuzzyRowFilter(FuzzyFilterPair filter_pair) {
        this.filter_pairs = Collections.singleton(filter_pair);
    }

    public FuzzyRowFilter(Collection<FuzzyFilterPair> filter_pairs) {
        this.filter_pairs = filter_pairs;
    }

    @Override
    byte[] name() {
        return NAME;
    }

    @Override
    byte[] serialize() {
        FilterPB.FuzzyRowFilter.Builder builder = FilterPB.FuzzyRowFilter.newBuilder();
        for (FuzzyFilterPair filter_pair : this.filter_pairs) {
            builder.addFuzzyKeysData(HBasePB.BytesBytesPair.newBuilder().setFirst(ByteString.copyFrom((byte[])filter_pair.getRowKey())).setSecond(ByteString.copyFrom((byte[])filter_pair.getFuzzyMask())));
        }
        return builder.build().toByteArray();
    }

    @Override
    void serializeOld(ChannelBuffer buf) {
        buf.writeByte((int)((byte)NAME.length));
        buf.writeBytes(NAME);
        buf.writeInt(this.filter_pairs.size());
        for (FuzzyFilterPair filter : this.filter_pairs) {
            HBaseRpc.writeByteArray(buf, filter.getRowKey());
            HBaseRpc.writeByteArray(buf, filter.getFuzzyMask());
        }
    }

    @Override
    int predictSerializedSize() {
        int size = 50;
        for (FuzzyFilterPair filter : this.filter_pairs) {
            size += 2 * (3 + filter.getRowKey().length);
        }
        return size;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("FuzzyFilter{").append(this.filter_pairs).append("}");
        return buf.toString();
    }

    @Override
    protected ByteString getState() {
        Dbfilters.FuzzyRowFilterProto.Builder frfp = Dbfilters.FuzzyRowFilterProto.newBuilder();
        for (FuzzyFilterPair filter_pair : this.filter_pairs) {
            Dbfilters.BytesBytesPairProto.Builder pairBuilder = Dbfilters.BytesBytesPairProto.newBuilder();
            pairBuilder.setFirst(Bytes.wrap(filter_pair.getRowKey()));
            pairBuilder.setSecond(Bytes.wrap(filter_pair.getFuzzyMask()));
            frfp.addFuzzyKeysData(pairBuilder.build());
        }
        return frfp.build().toByteString();
    }

    @Override
    protected String getId() {
        return FuzzyRowFilter.getFilterId(-707981514);
    }

    public static class FuzzyFilterPair {
        private final byte[] row_key;
        private final byte[] fuzzy_mask;

        public FuzzyFilterPair(byte[] row_key, byte[] fuzzy_mask) {
            if (row_key.length != fuzzy_mask.length) {
                throw new IllegalArgumentException("Row key and fuzzy mask length must match");
            }
            this.row_key = row_key;
            this.fuzzy_mask = fuzzy_mask;
        }

        public byte[] getRowKey() {
            return this.row_key;
        }

        public byte[] getFuzzyMask() {
            return this.fuzzy_mask;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("FuzzyFilterPair{row_key=").append(Bytes.pretty(this.row_key)).append(", mask=").append(Bytes.pretty(this.fuzzy_mask)).append("}");
            return buf.toString();
        }
    }
}

