/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.mapr.fs.proto.Dbfilters;
import java.util.List;
import org.hbase.async.Bytes;
import org.hbase.async.ScanFilter;
import org.hbase.async.generated.FilterPB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class FilterList
extends ScanFilter {
    private static final byte[] NAME = Bytes.ISO88591("org.apache.hadoop.hbase.filter.FilterList");
    private final List<ScanFilter> filters;
    private final Operator op;
    private static final int kFilterList = -1540440220;

    public FilterList(List<ScanFilter> filters) {
        this(filters, Operator.MUST_PASS_ALL);
    }

    public FilterList(List<ScanFilter> filters, Operator op) {
        if (filters.isEmpty()) {
            throw new IllegalArgumentException("Empty filter list");
        }
        this.filters = filters;
        this.op = op;
    }

    public int size() {
        return this.filters.size();
    }

    public List<ScanFilter> filters() {
        return ImmutableList.copyOf(this.filters);
    }

    @Override
    byte[] serialize() {
        FilterPB.FilterList.Builder filter = FilterPB.FilterList.newBuilder();
        if (this.op == Operator.MUST_PASS_ALL) {
            filter.setOperator(FilterPB.FilterList.Operator.MUST_PASS_ALL);
        } else {
            filter.setOperator(FilterPB.FilterList.Operator.MUST_PASS_ONE);
        }
        for (ScanFilter f : this.filters) {
            FilterPB.Filter nested = FilterPB.Filter.newBuilder().setNameBytes(Bytes.wrap(f.name())).setSerializedFilter(Bytes.wrap(f.serialize())).build();
            filter.addFilters(nested);
        }
        return filter.build().toByteArray();
    }

    @Override
    byte[] name() {
        return NAME;
    }

    @Override
    int predictSerializedSize() {
        int size = 1 + NAME.length + 1 + 4;
        for (ScanFilter filter : this.filters) {
            size += 2;
            size += filter.predictSerializedSize();
        }
        return size;
    }

    @Override
    void serializeOld(ChannelBuffer buf) {
        buf.writeByte((int)((byte)NAME.length));
        buf.writeBytes(NAME);
        buf.writeByte((int)((byte)this.op.ordinal()));
        buf.writeInt(this.filters.size());
        for (ScanFilter filter : this.filters) {
            buf.writeByte(54);
            buf.writeByte(0);
            filter.serializeOld(buf);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(32 + this.filters.size() * 48);
        buf.append("FilterList(filters=[");
        for (ScanFilter filter : this.filters) {
            buf.append(filter.toString());
            buf.append(", ");
        }
        buf.setLength(buf.length() - 2);
        buf.append("], op=").append((Object)this.op).append(")");
        return buf.toString();
    }

    @Override
    protected ByteString getState() {
        Dbfilters.FilterListProto.Builder builder = Dbfilters.FilterListProto.newBuilder();
        Dbfilters.FilterListProto.OperatorProto oproto = this.op == Operator.MUST_PASS_ALL ? Dbfilters.FilterListProto.OperatorProto.MUST_PASS_ALL : Dbfilters.FilterListProto.OperatorProto.MUST_PASS_ONE;
        builder.setOperator(oproto);
        for (ScanFilter filter : this.filters) {
            builder.addFilters(filter.getFilterMsg());
        }
        return builder.build().toByteString();
    }

    @Override
    protected String getId() {
        return FilterList.getFilterId(-1540440220);
    }

    public static enum Operator {
        MUST_PASS_ALL,
        MUST_PASS_ONE;

    }
}

