/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.ByteString;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseRpc;
import org.hbase.async.InvalidResponseException;
import org.hbase.async.KeyValue;
import org.hbase.async.PutRequest;
import org.hbase.async.generated.ClientPB;
import org.hbase.async.generated.ComparatorPB;
import org.hbase.async.generated.HBasePB;
import org.jboss.netty.buffer.ChannelBuffer;

final class CompareAndSetRequest
extends HBaseRpc
implements HBaseRpc.HasTable,
HBaseRpc.HasKey,
HBaseRpc.HasFamily,
HBaseRpc.HasQualifier,
HBaseRpc.HasValue,
HBaseRpc.IsEdit {
    private static final byte[] CHECKANDPUT = new byte[]{99, 104, 101, 99, 107, 65, 110, 100, 80, 117, 116};
    private static final ByteString BINARYCOMPARATOR = ByteString.copyFromUtf8((String)"org.apache.hadoop.hbase.filter.BinaryComparator");
    protected final PutRequest put;
    protected final byte[] expected;

    public CompareAndSetRequest(PutRequest put, byte[] expected) {
        super(put.table(), put.key());
        if (expected != null) {
            KeyValue.checkValue(expected);
        }
        this.put = put;
        this.expected = expected;
    }

    @Override
    byte[] method(byte server_version) {
        return server_version >= 95 ? MUTATE : CHECKANDPUT;
    }

    @Override
    public byte[] table() {
        return this.put.table();
    }

    @Override
    public byte[] key() {
        return this.put.key();
    }

    @Override
    public byte[] family() {
        return this.put.family();
    }

    @Override
    public byte[][] getFamilies() {
        return this.put.getFamilies();
    }

    @Override
    public byte[] qualifier() {
        return this.put.qualifier();
    }

    public long timestamp() {
        return this.put.timestamp();
    }

    public byte[] expectedValue() {
        return this.expected;
    }

    @Override
    public byte[] value() {
        return this.put.value();
    }

    private int predictSerializedSize() {
        int size = 0;
        size += 4;
        ++size;
        size += 3;
        size += this.region.name().length;
        ++size;
        size += 3;
        size += this.key.length;
        ++size;
        size += 3;
        size += this.put.family().length;
        ++size;
        size += 3;
        size += this.put.qualifier().length;
        ++size;
        size += 4;
        size += this.expected.length;
        return size += this.put.predictPutSize();
    }

    @Override
    ChannelBuffer serialize(byte server_version) {
        if (server_version < 95) {
            return this.serializeOld(server_version);
        }
        ByteString key = Bytes.wrap(this.put.key());
        ByteString family = Bytes.wrap(this.put.family());
        ByteString qualifier = Bytes.wrap(this.put.qualifier());
        ByteString value = Bytes.wrap(this.put.value());
        ClientPB.MutationProto.ColumnValue.QualifierValue qual = ClientPB.MutationProto.ColumnValue.QualifierValue.newBuilder().setQualifier(qualifier).setValue(value).setTimestamp(this.put.timestamp()).build();
        ClientPB.MutationProto.ColumnValue column = ClientPB.MutationProto.ColumnValue.newBuilder().setFamily(family).addQualifierValue(qual).build();
        ClientPB.MutationProto.Builder put = ClientPB.MutationProto.newBuilder().setRow(key).setMutateType(ClientPB.MutationProto.MutationType.PUT).addColumnValue(column);
        ComparatorPB.ByteArrayComparable expected = ComparatorPB.ByteArrayComparable.newBuilder().setValue(Bytes.wrap(this.expected)).build();
        ComparatorPB.BinaryComparator cmp = ComparatorPB.BinaryComparator.newBuilder().setComparable(expected).build();
        ComparatorPB.Comparator comparator = ComparatorPB.Comparator.newBuilder().setNameBytes(BINARYCOMPARATOR).setSerializedComparator(Bytes.wrap(cmp.toByteArray())).build();
        ClientPB.Condition cond = ClientPB.Condition.newBuilder().setRow(key).setFamily(family).setQualifier(qualifier).setCompareType(HBasePB.CompareType.EQUAL).setComparator(comparator).build();
        ClientPB.MutateRequest req = ClientPB.MutateRequest.newBuilder().setRegion(this.region.toProtobuf()).setMutation(put.build()).setCondition(cond).build();
        return CompareAndSetRequest.toChannelBuffer(MUTATE, (AbstractMessageLite)req);
    }

    private ChannelBuffer serializeOld(byte server_version) {
        ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize());
        buf.writeInt(6);
        CompareAndSetRequest.writeHBaseByteArray(buf, this.region.name());
        CompareAndSetRequest.writeHBaseByteArray(buf, this.put.key());
        CompareAndSetRequest.writeHBaseByteArray(buf, this.put.family());
        CompareAndSetRequest.writeHBaseByteArray(buf, this.put.qualifier());
        CompareAndSetRequest.writeHBaseByteArray(buf, this.expected);
        this.put.serializeInto(buf);
        return buf;
    }

    @Override
    Boolean deserialize(ChannelBuffer buf, int cell_size) {
        HBaseRpc.ensureNoCell(cell_size);
        ClientPB.MutateResponse resp = CompareAndSetRequest.readProtobuf(buf, ClientPB.MutateResponse.PARSER);
        if (!resp.hasProcessed()) {
            throw new InvalidResponseException("After a CAS on " + this.put + ", the protobuf in the response didn't contain the field indicating whether the CAS was successful or not", (Object)resp);
        }
        return resp.getProcessed();
    }
}

