/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.LiteralByteStringAsyncHBase;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZeroCopyLiteralByteString
extends LiteralByteStringAsyncHBase {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ZeroCopyLiteralByteString.class);
    private static final Class<?> _clsLiteralByteString;
    private static final Field _fieldBytes;
    private static final boolean _canUseEfficientCopy;

    private ZeroCopyLiteralByteString() {
        super(null);
        throw new UnsupportedOperationException("Should never be here.");
    }

    public static ByteString wrap(byte[] array) {
        return new LiteralByteStringAsyncHBase(array);
    }

    public static byte[] zeroCopyGetBytes(ByteString buf) {
        if (buf instanceof LiteralByteStringAsyncHBase) {
            return ((LiteralByteStringAsyncHBase)buf).bytes;
        }
        if (_clsLiteralByteString.isAssignableFrom(buf.getClass())) {
            if (_canUseEfficientCopy) {
                try {
                    return (byte[])_fieldBytes.get(buf);
                }
                catch (Throwable e) {
                    throw new RuntimeException("Unexpected Exception while accessing internal field `bytes`.", e);
                }
            }
            return buf.toByteArray();
        }
        throw new UnsupportedOperationException("Need a LiteralByteString or LiteralByteStringAsyncHBase, got a " + buf.getClass().getName());
    }

    static {
        Class<?> clsLiteralByteString = null;
        Field fieldBytes = null;
        boolean canUseEfficientCopy = false;
        try {
            clsLiteralByteString = Class.forName("com.google.protobuf.ByteString$LiteralByteString");
            fieldBytes = clsLiteralByteString.getDeclaredField("bytes");
            fieldBytes.setAccessible(true);
            ByteString testByteString = ByteString.copyFromUtf8((String)"");
            byte[] wrappedBytes = (byte[])fieldBytes.get(testByteString);
            canUseEfficientCopy = true;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            LOG.warn("AsyncHBase: Could not load/access 'com.google.protobuf.ByteString$LiteralByteString' class.Make sure Google Protobuf version library > 3.5 is in the classpath", (Throwable)e);
            LOG.warn("Protobuf zero-copy feature will be unavailable.");
        }
        LOG.info("Protobuf zero-copy feature initialized.");
        _clsLiteralByteString = clsLiteralByteString;
        _fieldBytes = fieldBytes;
        _canUseEfficientCopy = canUseEfficientCopy;
    }
}

