/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.BoundedByteStringAsyncHBase;
import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Internal;
import com.google.protobuf.Utf8;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;

class LiteralByteStringAsyncHBase
extends ByteString.LeafByteString {
    private static final long serialVersionUID = 1L;
    protected final byte[] bytes;

    LiteralByteStringAsyncHBase(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException();
        }
        this.bytes = bytes;
    }

    public byte byteAt(int index) {
        return this.bytes[index];
    }

    byte internalByteAt(int index) {
        return this.bytes[index];
    }

    public int size() {
        return this.bytes.length;
    }

    public final ByteString substring(int beginIndex, int endIndex) {
        int length = LiteralByteStringAsyncHBase.checkRange((int)beginIndex, (int)endIndex, (int)this.size());
        if (length == 0) {
            return ByteString.EMPTY;
        }
        return new BoundedByteStringAsyncHBase(this.bytes, this.getOffsetIntoBytes() + beginIndex, length);
    }

    protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        System.arraycopy(this.bytes, sourceOffset, target, targetOffset, numberToCopy);
    }

    public final void copyTo(ByteBuffer target) {
        target.put(this.bytes, this.getOffsetIntoBytes(), this.size());
    }

    public final ByteBuffer asReadOnlyByteBuffer() {
        return ByteBuffer.wrap(this.bytes, this.getOffsetIntoBytes(), this.size()).asReadOnlyBuffer();
    }

    public final List<ByteBuffer> asReadOnlyByteBufferList() {
        return Collections.singletonList(this.asReadOnlyByteBuffer());
    }

    public final void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }

    final void writeToInternal(OutputStream outputStream, int sourceOffset, int numberToWrite) throws IOException {
        outputStream.write(this.bytes, this.getOffsetIntoBytes() + sourceOffset, numberToWrite);
    }

    final void writeTo(ByteOutput output) throws IOException {
        output.writeLazy(this.bytes, this.getOffsetIntoBytes(), this.size());
    }

    protected final String toStringInternal(Charset charset) {
        return new String(this.bytes, this.getOffsetIntoBytes(), this.size(), charset);
    }

    public final boolean isValidUtf8() {
        int offset = this.getOffsetIntoBytes();
        return Utf8.isValidUtf8((byte[])this.bytes, (int)offset, (int)(offset + this.size()));
    }

    protected final int partialIsValidUtf8(int state, int offset, int length) {
        int index = this.getOffsetIntoBytes() + offset;
        return Utf8.partialIsValidUtf8((int)state, (byte[])this.bytes, (int)index, (int)(index + length));
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ByteString)) {
            return false;
        }
        if (this.size() != ((ByteString)other).size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        if (other instanceof LiteralByteStringAsyncHBase) {
            LiteralByteStringAsyncHBase otherAsLiteral = (LiteralByteStringAsyncHBase)((Object)other);
            int thisHash = this.peekCachedHashCode();
            int thatHash = otherAsLiteral.peekCachedHashCode();
            if (thisHash != 0 && thatHash != 0 && thisHash != thatHash) {
                return false;
            }
            return this.equalsRange((ByteString)((LiteralByteStringAsyncHBase)((Object)other)), 0, this.size());
        }
        return other.equals((Object)this);
    }

    final boolean equalsRange(ByteString other, int offset, int length) {
        if (length > other.size()) {
            throw new IllegalArgumentException("Length too large: " + length + this.size());
        }
        if (offset + length > other.size()) {
            throw new IllegalArgumentException("Ran off end of other: " + offset + ", " + length + ", " + other.size());
        }
        if (other instanceof LiteralByteStringAsyncHBase) {
            LiteralByteStringAsyncHBase lbsOther = (LiteralByteStringAsyncHBase)other;
            byte[] thisBytes = this.bytes;
            byte[] otherBytes = lbsOther.bytes;
            int thisLimit = this.getOffsetIntoBytes() + length;
            int thisIndex = this.getOffsetIntoBytes();
            int otherIndex = lbsOther.getOffsetIntoBytes() + offset;
            while (thisIndex < thisLimit) {
                if (thisBytes[thisIndex] != otherBytes[otherIndex]) {
                    return false;
                }
                ++thisIndex;
                ++otherIndex;
            }
            return true;
        }
        return other.substring(offset, offset + length).equals((Object)this.substring(0, length));
    }

    protected final int partialHash(int h, int offset, int length) {
        return Internal.partialHash((int)h, (byte[])this.bytes, (int)(this.getOffsetIntoBytes() + offset), (int)length);
    }

    public final InputStream newInput() {
        return new ByteArrayInputStream(this.bytes, this.getOffsetIntoBytes(), this.size());
    }

    public final CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance((byte[])this.bytes, (int)this.getOffsetIntoBytes(), (int)this.size(), (boolean)true);
    }

    protected int getOffsetIntoBytes() {
        return 0;
    }
}

