/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.LiteralByteStringAsyncHBase;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;

final class BoundedByteStringAsyncHBase
extends LiteralByteStringAsyncHBase {
    private final int bytesOffset;
    private final int bytesLength;
    private static final long serialVersionUID = 1L;

    BoundedByteStringAsyncHBase(byte[] bytes, int offset, int length) {
        super(bytes);
        BoundedByteStringAsyncHBase.checkRange((int)offset, (int)(offset + length), (int)bytes.length);
        this.bytesOffset = offset;
        this.bytesLength = length;
    }

    @Override
    public byte byteAt(int index) {
        BoundedByteStringAsyncHBase.checkIndex((int)index, (int)this.size());
        return this.bytes[this.bytesOffset + index];
    }

    @Override
    byte internalByteAt(int index) {
        return this.bytes[this.bytesOffset + index];
    }

    @Override
    public int size() {
        return this.bytesLength;
    }

    @Override
    protected int getOffsetIntoBytes() {
        return this.bytesOffset;
    }

    @Override
    protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        System.arraycopy(this.bytes, this.getOffsetIntoBytes() + sourceOffset, target, targetOffset, numberToCopy);
    }

    Object writeReplace() {
        return ByteString.wrap((byte[])this.toByteArray());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new InvalidObjectException("BoundedByteStream instances are not to be serialized directly");
    }
}

