/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.mapr.fs.proto.Dbfilters;
import java.util.Collection;
import java.util.TreeSet;
import org.hbase.async.Bytes;
import org.hbase.async.ScanFilter;
import org.hbase.async.generated.FilterPB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class TimestampsFilter
extends ScanFilter {
    private static final byte[] NAME = Bytes.UTF8("org.apache.hadoop.hbase.filter.TimestampsFilter");
    private final TreeSet<Long> timestamps;
    public static final int kTimestampsFilter = -109471581;

    public TimestampsFilter(Collection<Long> timestamps) {
        this.timestamps = new TreeSet<Long>(timestamps);
    }

    public TimestampsFilter(Long ... timestamps) {
        this(Lists.newArrayList((Object[])timestamps));
    }

    @Override
    byte[] name() {
        return NAME;
    }

    @Override
    byte[] serialize() {
        FilterPB.TimestampsFilter.Builder builder = FilterPB.TimestampsFilter.newBuilder();
        builder.addAllTimestamps(this.timestamps);
        return builder.build().toByteArray();
    }

    @Override
    void serializeOld(ChannelBuffer buf) {
        buf.writeByte((int)((byte)NAME.length));
        buf.writeBytes(NAME);
        buf.writeInt(this.timestamps.size());
        for (Long timestamp : this.timestamps) {
            buf.writeLong(timestamp.longValue());
        }
    }

    @Override
    int predictSerializedSize() {
        return 52 + this.timestamps.size() * 8;
    }

    @Override
    protected ByteString getState() {
        Dbfilters.TimestampsFilterProto.Builder builder = Dbfilters.TimestampsFilterProto.newBuilder();
        for (Long timestamp : this.timestamps) {
            builder.addTimestamps(timestamp.longValue());
        }
        return builder.build().toByteString();
    }

    @Override
    protected String getId() {
        return TimestampsFilter.getFilterId(-109471581);
    }
}

