/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.AbstractMessageLite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.hbase.async.BatchableRpc;
import org.hbase.async.Bytes;
import org.hbase.async.DeleteRequest;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseException;
import org.hbase.async.HBaseRpc;
import org.hbase.async.HasFailedRpcException;
import org.hbase.async.InvalidResponseException;
import org.hbase.async.NonRecoverableException;
import org.hbase.async.NotServingRegionException;
import org.hbase.async.PutRequest;
import org.hbase.async.RecoverableException;
import org.hbase.async.RegionClient;
import org.hbase.async.RegionInfo;
import org.hbase.async.generated.ClientPB;
import org.hbase.async.generated.HBasePB;
import org.jboss.netty.buffer.ChannelBuffer;

final class MultiAction
extends HBaseRpc
implements HBaseRpc.IsEdit {
    private static final byte[] MULTI_PUT = new byte[]{109, 117, 108, 116, 105, 80, 117, 116};
    private static final byte[] MULTI = new byte[]{109, 117, 108, 116, 105};
    private static final byte[] MMULTI = new byte[]{77, 117, 108, 116, 105};
    private static final NotServingRegionException NSRE = new NotServingRegionException("Region unavailable", null);
    static final byte USE_MULTI = 29;
    private final ArrayList<BatchableRpc> batch = new ArrayList();
    static final MultiActionComparator MULTI_CMP = new MultiActionComparator();
    static final RegionComparator SORT_BY_REGION = new RegionComparator();
    private static final MultiActionSuccess SUCCESS = new MultiActionSuccess();

    MultiAction() {
    }

    @Override
    byte[] method(byte server_version) {
        if (server_version >= 95) {
            return MMULTI;
        }
        return server_version >= 29 ? MULTI : MULTI_PUT;
    }

    public int size() {
        return this.batch.size();
    }

    public void add(BatchableRpc rpc) {
        if (rpc.lockid != -1L) {
            throw new AssertionError((Object)("Should never happen!  We don't do multi-put with RowLocks but we've been given an edit that has one!  edit=" + rpc + ", this=" + this));
        }
        this.batch.add(rpc);
    }

    ArrayList<BatchableRpc> batch() {
        return this.batch;
    }

    private int predictSerializedSize(byte server_version) {
        int size = 0;
        size += 4;
        ++size;
        ++size;
        size += 4;
        boolean use_multi = this.method(server_version) == MULTI;
        BatchableRpc prev = PutRequest.EMPTY_PUT;
        for (BatchableRpc rpc : this.batch) {
            boolean new_family;
            byte[] region_name = rpc.getRegion().name();
            boolean new_region = !Bytes.equals(prev.getRegion().name(), region_name);
            byte[][] families = rpc.getFamilies();
            boolean new_key = new_region || ((BatchableRpc)prev).code() != rpc.code() || !Bytes.equals(prev.key, rpc.key) || families.length > 1 || prev.getFamilies().length > 1 || families == DeleteRequest.WHOLE_ROW;
            boolean bl = new_family = new_key || !Bytes.equals(prev.family(), families[0]);
            if (new_region) {
                size += 3;
                size += region_name.length;
                size += 4;
            }
            int key_length = rpc.key.length;
            if (new_key) {
                if (use_multi) {
                    size += 4;
                    size += 4;
                    size += 3;
                    ++size;
                    ++size;
                    ++size;
                    ++size;
                }
                ++size;
                size += 3;
                size += key_length;
                size += 8;
                size += 8;
                ++size;
                size += 4;
            }
            if (new_family) {
                if (families.length > 1) {
                    size += rpc.payloadsSize();
                    prev = rpc;
                    continue;
                }
                ++size;
                size += families[0].length;
                size += 4;
                if (rpc.code() == 35) {
                    size += 4;
                }
            }
            size += rpc.payloadSize();
            prev = rpc;
        }
        return size;
    }

    @Override
    ChannelBuffer serialize(byte server_version) {
        if (server_version < 95) {
            return this.serializeOld(server_version);
        }
        Collections.sort(this.batch, SORT_BY_REGION);
        ClientPB.MultiRequest.Builder req = ClientPB.MultiRequest.newBuilder();
        ClientPB.RegionAction.Builder actions = null;
        byte[] prev_region = HBaseClient.EMPTY_ARRAY;
        int i = 0;
        for (BatchableRpc rpc : this.batch) {
            boolean new_region;
            RegionInfo region = rpc.getRegion();
            boolean bl = new_region = !Bytes.equals(prev_region, region.name());
            if (new_region) {
                if (actions != null) {
                    req.addRegionAction(actions.build());
                }
                actions = ClientPB.RegionAction.newBuilder();
                actions.setRegion(rpc.getRegion().toProtobuf());
                prev_region = region.name();
            }
            ClientPB.Action action = ClientPB.Action.newBuilder().setIndex(i++).setMutation(rpc.toMutationProto()).build();
            actions.addAction(action);
        }
        req.addRegionAction(actions.build());
        return MultiAction.toChannelBuffer(MMULTI, (AbstractMessageLite)req.build());
    }

    private ChannelBuffer serializeOld(byte server_version) {
        Collections.sort(this.batch, MULTI_CMP);
        ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize(server_version));
        buf.writeInt(1);
        boolean use_multi = this.method(server_version) == MULTI;
        int code = use_multi ? 66 : 57;
        buf.writeByte(code);
        buf.writeByte(code);
        buf.writeInt(0);
        int nregions = 0;
        int nkeys_index = -1;
        int nkeys = 0;
        int nfamilies_index = -1;
        int nfamilies = 0;
        int nkeys_per_family_index = -1;
        int nkeys_per_family = 0;
        int nbytes_per_family = 0;
        int nrpcs_per_key = 0;
        BatchableRpc prev = PutRequest.EMPTY_PUT;
        for (BatchableRpc rpc : this.batch) {
            boolean new_family;
            byte[] region_name = rpc.getRegion().name();
            boolean new_region = !Bytes.equals(prev.getRegion().name(), region_name);
            byte[][] families = rpc.getFamilies();
            boolean new_key = new_region || ((BatchableRpc)prev).code() != rpc.code() || !Bytes.equals(prev.key, rpc.key) || families.length > 1 || prev.getFamilies().length > 1 || families == DeleteRequest.WHOLE_ROW;
            boolean bl = new_family = new_key || !Bytes.equals(prev.family(), families[0]);
            if (new_key && use_multi && nkeys_index > 0) {
                buf.writeInt(0);
                buf.writeInt(nrpcs_per_key);
                nrpcs_per_key = 0;
                MultiAction.writeHBaseNull(buf);
            }
            if (new_region) {
                if (nkeys_index > 0) {
                    buf.setInt(nkeys_index, nkeys);
                    nkeys = 0;
                }
                ++nregions;
                MultiAction.writeByteArray(buf, region_name);
                nkeys_index = buf.writerIndex();
                buf.writeInt(0);
            }
            byte[] key = rpc.key;
            if (new_key) {
                if (nfamilies_index > 0) {
                    buf.setInt(nfamilies_index, nfamilies);
                    nfamilies = 0;
                }
                if (use_multi) {
                    buf.writeByte(65);
                    buf.writeByte(65);
                    buf.writeByte(64);
                    buf.writeByte((int)rpc.code());
                }
                ++nkeys;
                buf.writeByte((int)rpc.version(server_version));
                MultiAction.writeByteArray(buf, key);
                buf.writeLong(rpc.timestamp);
                buf.writeLong(-1L);
                buf.writeByte(rpc.durable ? 1 : 0);
                nfamilies_index = buf.writerIndex();
                buf.writeInt(0);
            }
            if (new_family) {
                if (nkeys_per_family_index > 0) {
                    buf.setInt(nkeys_per_family_index, nkeys_per_family);
                    if (((BatchableRpc)prev).code() == 35) {
                        buf.setInt(nkeys_per_family_index + 4, nbytes_per_family);
                    }
                    nkeys_per_family_index = -1;
                    nkeys_per_family = 0;
                    nbytes_per_family = 0;
                }
                if (families == DeleteRequest.WHOLE_ROW) {
                    prev = rpc;
                    continue;
                }
                if (families.length > 1) {
                    nfamilies = families.length;
                    rpc.serializePayloads(buf);
                    ++nrpcs_per_key;
                    prev = rpc;
                    continue;
                }
                ++nfamilies;
                MultiAction.writeByteArray(buf, families[0]);
                nkeys_per_family_index = buf.writerIndex();
                buf.writeInt(0);
                if (rpc.code() == 35) {
                    buf.writeInt(0);
                }
            }
            nkeys_per_family += rpc.numKeyValues();
            ++nrpcs_per_key;
            nbytes_per_family += rpc.payloadSize();
            rpc.serializePayload(buf);
            prev = rpc;
        }
        if (use_multi) {
            buf.writeInt(0);
            buf.writeInt(nrpcs_per_key);
            MultiAction.writeHBaseNull(buf);
        }
        if (nkeys_per_family_index > 0) {
            buf.setInt(nkeys_per_family_index, nkeys_per_family);
            if (((BatchableRpc)prev).code() == 35) {
                buf.setInt(nkeys_per_family_index + 4, nbytes_per_family);
            }
        }
        buf.setInt(nfamilies_index, nfamilies);
        buf.setInt(nkeys_index, nkeys);
        int header_length = 10 + this.method(server_version).length;
        if (server_version >= 29) {
            header_length += 13;
        }
        buf.setInt(header_length + 4 + 1 + 1, nregions);
        return buf;
    }

    @Override
    public String toString() {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("MultiAction(batch=[");
        int nrpcs = this.batch.size();
        for (i = 0; i < nrpcs && buf.length() < 1024; ++i) {
            buf.append(this.batch.get(i)).append(", ");
        }
        if (i < nrpcs) {
            if (i == nrpcs - 1) {
                buf.append("... 1 RPC not shown])");
            } else {
                buf.append("... ").append(nrpcs - 1 - i).append(" RPCs not shown ..., ").append(this.batch.get(nrpcs - 1)).append("])");
            }
        } else {
            buf.setLength(buf.length() - 2);
            buf.append("])");
        }
        return buf.toString();
    }

    @Override
    Object deserialize(ChannelBuffer buf, int cell_size) {
        HBaseRpc.ensureNoCell(cell_size);
        ClientPB.MultiResponse resp = MultiAction.readProtobuf(buf, ClientPB.MultiResponse.PARSER);
        int nrpcs = this.batch.size();
        Object[] resps = new Object[nrpcs];
        int n = 0;
        int r = 0;
        while (n < nrpcs) {
            ClientPB.RegionActionResult results = resp.getRegionActionResult(r++);
            int nresults = results.getResultOrExceptionCount();
            if (results.hasException()) {
                int last_edit;
                if (nresults != 0) {
                    throw new InvalidResponseException("All edits in a batch failed yet we found " + nresults + " results", (Object)results);
                }
                byte[] region_name = this.batch.get(n).getRegion().name();
                for (last_edit = n + 1; last_edit < nrpcs && Bytes.equals(region_name, this.batch.get(last_edit).getRegion().name()); ++last_edit) {
                }
                HBasePB.NameBytesPair pair = results.getException();
                for (int j = n; j < last_edit; ++j) {
                    resps[j] = RegionClient.decodeExceptionPair(this.batch.get(j), pair);
                }
                n = last_edit;
                continue;
            }
            for (int j = 0; j < nresults; ++j) {
                Object result;
                ClientPB.ResultOrException roe = results.getResultOrException(j);
                int index = roe.getIndex();
                if (index != n) {
                    throw new InvalidResponseException("Expected result #" + n + " but got result #" + index, (Object)results);
                }
                if (roe.hasException()) {
                    HBasePB.NameBytesPair pair = roe.getException();
                    result = RegionClient.decodeExceptionPair(this.batch.get(n), pair);
                } else {
                    result = SUCCESS;
                }
                resps[n++] = result;
            }
        }
        if (n != nrpcs) {
            throw new InvalidResponseException("Expected " + nrpcs + " results but got " + n, (Object)resp);
        }
        return new Response(resps);
    }

    Response responseFromBuffer(ChannelBuffer buf) {
        switch (buf.readByte()) {
            case 58: {
                return this.deserializeMultiPutResponse(buf);
            }
            case 67: {
                return this.deserializeMultiResponse(buf);
            }
        }
        throw new NonRecoverableException("Couldn't de-serialize " + Bytes.pretty(buf));
    }

    Response deserializeMultiResponse(ChannelBuffer buf) {
        int nregions = buf.readInt();
        HBaseRpc.checkNonEmptyArrayLength(buf, nregions);
        Object[] resps = new Object[this.batch.size()];
        int n = 0;
        for (int i = 0; i < nregions; ++i) {
            byte[] region_name = HBaseRpc.readByteArray(buf);
            int nkeys = buf.readInt();
            HBaseRpc.checkNonEmptyArrayLength(buf, nkeys);
            for (int j = 0; j < nkeys; ++j) {
                Object resp;
                HBaseException e;
                boolean error;
                int nrpcs_per_key = buf.readInt();
                boolean bl = error = buf.readByte() != 0;
                if (error) {
                    e = RegionClient.deserializeException(buf, null);
                    resp = e;
                } else {
                    resp = RegionClient.deserializeObject(buf, this);
                    if (resp instanceof ArrayList && ((ArrayList)resp).isEmpty()) {
                        resp = SUCCESS;
                    } else if (resp == null) {
                        resp = NSRE;
                        error = true;
                    }
                }
                if (error) {
                    e = (HBaseException)resp;
                    for (int k = 0; k < nrpcs_per_key; ++k) {
                        resps[n + k] = e.make(e, this.batch.get(n + k));
                    }
                } else {
                    for (int k = 0; k < nrpcs_per_key; ++k) {
                        resps[n + k] = resp;
                    }
                }
                n += nrpcs_per_key;
            }
        }
        return new Response(resps);
    }

    Response deserializeMultiPutResponse(ChannelBuffer buf) {
        int nregions = buf.readInt();
        HBaseRpc.checkNonEmptyArrayLength(buf, nregions);
        int nrpcs = this.batch.size();
        Object[] resps = new Object[nrpcs];
        int n = 0;
        for (int i = 0; i < nregions; ++i) {
            int j;
            int edits_per_region;
            byte[] region_name = HBaseRpc.readByteArray(buf);
            assert (Bytes.equals(region_name, this.batch.get(n).getRegion().name())) : "WTF?  " + Bytes.pretty(region_name) + " != " + this.batch.get(n).getRegion().name();
            int failed = buf.readInt();
            for (edits_per_region = n; edits_per_region < nrpcs && Bytes.equals(region_name, this.batch.get(edits_per_region).getRegion().name()); ++edits_per_region) {
            }
            assert (failed < (edits_per_region -= n)) : "WTF? Found more failed RPCs " + failed + " than sent " + edits_per_region + " to " + Bytes.pretty(region_name);
            if (failed == -1) {
                for (j = 0; j < edits_per_region; ++j) {
                    resps[n + j] = SUCCESS;
                }
            } else {
                assert (failed >= 0) : "WTF?  Found a negative failure index " + failed + " for region " + Bytes.pretty(region_name);
                for (j = 0; j < failed; ++j) {
                    resps[n + j] = SUCCESS;
                }
                String msg = "Multi-put failed on RPC #" + failed + "/" + edits_per_region + " on region " + Bytes.pretty(region_name);
                for (int j2 = failed; j2 < edits_per_region; ++j2) {
                    resps[n + j2] = new MultiPutFailedException(msg, this.batch.get(n + j2));
                }
            }
            n += edits_per_region;
        }
        return new Response(resps);
    }

    private static final class MultiActionSuccess {
        private MultiActionSuccess() {
        }

        public String toString() {
            return "MultiActionSuccess";
        }
    }

    private final class MultiPutFailedException
    extends RecoverableException
    implements HasFailedRpcException {
        final HBaseRpc failed_rpc;
        private static final long serialVersionUID = 1326900942L;

        MultiPutFailedException(String msg, HBaseRpc failed_rpc) {
            super(msg);
            this.failed_rpc = failed_rpc;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + "\nCaused by RPC: " + this.failed_rpc;
        }

        @Override
        public HBaseRpc getFailedRpc() {
            return this.failed_rpc;
        }

        @Override
        MultiPutFailedException make(Object msg, HBaseRpc rpc) {
            if (msg == this || msg instanceof MultiPutFailedException) {
                MultiPutFailedException e = (MultiPutFailedException)msg;
                return new MultiPutFailedException(e.getMessage(), rpc);
            }
            return new MultiPutFailedException(msg.toString(), rpc);
        }
    }

    final class Response {
        private final Object[] resps;

        Response(Object[] resps) {
            assert (resps.length == MultiAction.this.batch.size()) : "Got " + resps.length + " responses but expected " + MultiAction.access$200(multiAction).size();
            this.resps = resps;
        }

        public Object result(int i) {
            return this.resps[i];
        }

        public String toString() {
            return "MultiAction.Response(" + Arrays.toString(this.resps) + ')';
        }
    }

    private static final class RegionComparator
    implements Comparator<BatchableRpc> {
        private RegionComparator() {
        }

        @Override
        public int compare(BatchableRpc a, BatchableRpc b) {
            return Bytes.memcmp(a.getRegion().name(), b.getRegion().name());
        }
    }

    private static final class MultiActionComparator
    implements Comparator<BatchableRpc> {
        private MultiActionComparator() {
        }

        @Override
        public int compare(BatchableRpc a, BatchableRpc b) {
            int d = Bytes.memcmp(a.getRegion().name(), b.getRegion().name());
            if (d != 0) {
                return d;
            }
            d = a.code() - b.code();
            if (d != 0) {
                return d;
            }
            d = Bytes.memcmp(a.key, b.key);
            if (d != 0) {
                return d;
            }
            if (a.getFamilies().length == 1 && b.getFamilies().length == 1) {
                return Bytes.memcmp(a.family(), b.family());
            }
            return a.getFamilies().length - b.getFamilies().length;
        }
    }
}

