/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.ByteString;
import com.mapr.fs.proto.Dbfilters;
import org.hbase.async.Bytes;
import org.hbase.async.CompareFilter;
import org.hbase.async.FilterComparator;
import org.hbase.async.HBaseRpc;
import org.hbase.async.generated.ComparatorPB;
import org.hbase.async.generated.FilterPB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class DependentColumnFilter
extends CompareFilter {
    private static final byte[] NAME = Bytes.UTF8("org.apache.hadoop.hbase.filter.DependentColumnFilter");
    private final byte[] family;
    private final byte[] qualifier;
    private final boolean drop_dependent_column;
    private static final FilterComparator NO_COMPARATOR = new FilterComparator(){

        @Override
        byte[] name() {
            return new byte[0];
        }

        @Override
        ComparatorPB.Comparator toProtobuf() {
            return null;
        }

        @Override
        void serializeOld(ChannelBuffer buf) {
            buf.writeByte(14);
            buf.writeByte(17);
            super.serializeOld(buf);
        }

        @Override
        int predictSerializedSize() {
            return 2 + super.predictSerializedSize();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        @Override
        protected ByteString getState() {
            return null;
        }

        @Override
        protected String getName() {
            return null;
        }
    };
    public static final int kDependentColumnFilter = 321328927;

    public DependentColumnFilter(byte[] family, byte[] qualifier, boolean drop_dependent_column, CompareFilter.CompareOp value_compare_op, FilterComparator value_comparator) {
        super(value_compare_op, value_comparator);
        this.family = family;
        this.qualifier = qualifier;
        this.drop_dependent_column = drop_dependent_column;
    }

    public DependentColumnFilter(byte[] family, byte[] qualifier, boolean drop_dependent_column) {
        this(family, qualifier, drop_dependent_column, CompareFilter.CompareOp.NO_OP, NO_COMPARATOR);
    }

    public DependentColumnFilter(byte[] family, byte[] qualifier, CompareFilter.CompareOp value_compare_op, FilterComparator value_comparator) {
        this(family, qualifier, false, value_compare_op, value_comparator);
    }

    public DependentColumnFilter(byte[] family, byte[] qualifier) {
        this(family, qualifier, false);
    }

    public byte[] family() {
        return (byte[])this.family.clone();
    }

    public byte[] qualifier() {
        return (byte[])this.qualifier.clone();
    }

    public boolean dropDependentColumn() {
        return this.drop_dependent_column;
    }

    @Override
    byte[] name() {
        return NAME;
    }

    @Override
    byte[] serialize() {
        return FilterPB.DependentColumnFilter.newBuilder().setCompareFilter(this.toProtobuf()).setColumnFamily(Bytes.wrap(this.family)).setColumnQualifier(Bytes.wrap(this.qualifier)).setDropDependentColumn(this.drop_dependent_column).build().toByteArray();
    }

    @Override
    void serializeOld(ChannelBuffer buf) {
        super.serializeOld(buf);
        HBaseRpc.writeByteArray(buf, this.family);
        HBaseRpc.writeByteArray(buf, this.qualifier);
        buf.writeByte(this.drop_dependent_column ? 1 : 0);
    }

    @Override
    int predictSerializedSize() {
        return super.predictSerializedSize() + 3 + this.family.length + 3 + this.qualifier.length + 1;
    }

    @Override
    public String toString() {
        return String.format("%s(%s, %s, %s, %s, %s)", this.getClass().getSimpleName(), Bytes.pretty(this.family), Bytes.pretty(this.qualifier), this.drop_dependent_column, this.compare_op.name(), this.comparator.toString());
    }

    @Override
    public ByteString getState() {
        return Dbfilters.DependentColumnFilterProto.newBuilder().setColumnFamily(ByteString.copyFrom((byte[])this.family)).setColumnQualifier(ByteString.copyFrom((byte[])this.qualifier)).setDropDependentColumn(this.drop_dependent_column).setFilterComparator(this.toFilterComparatorProto()).build().toByteString();
    }

    @Override
    protected String getId() {
        return DependentColumnFilter.getFilterId(321328927);
    }
}

