/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.mapr.fs.proto.Dbfilters;
import org.hbase.async.Bytes;
import org.hbase.async.FilterComparator;
import org.hbase.async.ScanFilter;
import org.hbase.async.generated.ComparatorPB;
import org.hbase.async.generated.FilterPB;
import org.hbase.async.generated.HBasePB;
import org.jboss.netty.buffer.ChannelBuffer;

public abstract class CompareFilter
extends ScanFilter {
    final CompareOp compare_op;
    final FilterComparator comparator;

    public CompareFilter(CompareOp compareOp, FilterComparator comparator) {
        this.compare_op = compareOp;
        this.comparator = comparator;
    }

    public CompareOp compareOperation() {
        return this.compare_op;
    }

    public FilterComparator comparator() {
        return this.comparator;
    }

    protected final FilterPB.CompareFilter toProtobuf() {
        FilterPB.CompareFilter.Builder builder = FilterPB.CompareFilter.newBuilder();
        ComparatorPB.Comparator comparator_pb = this.comparator.toProtobuf();
        if (comparator_pb != null) {
            builder.setComparator(comparator_pb);
        }
        return builder.setCompareOp(HBasePB.CompareType.valueOf(this.compare_op.name())).build();
    }

    @Override
    void serializeOld(ChannelBuffer buf) {
        buf.writeByte((int)((byte)this.name().length));
        buf.writeBytes(this.name());
        buf.writeShort(this.compare_op.name().length());
        buf.writeBytes(Bytes.UTF8(this.compare_op.name()));
        this.comparator.serializeOld(buf);
    }

    @Override
    int predictSerializedSize() {
        return 1 + this.name().length + 2 + this.compare_op.name().length() + this.comparator.predictSerializedSize();
    }

    public String toString() {
        return String.format("%s(%s, %s)", this.getClass().getSimpleName(), this.compare_op.name(), this.comparator.toString());
    }

    protected final Dbfilters.FilterComparatorProto toFilterComparatorProto() {
        Dbfilters.FilterComparatorProto.Builder builder = Dbfilters.FilterComparatorProto.newBuilder();
        builder.setCompareOp(Dbfilters.CompareOpProto.valueOf((String)this.compare_op.name()));
        if (this.comparator != null && this.comparator.getState() != null) {
            builder.setComparator(this.comparator.toComparatorProto());
        }
        return builder.build();
    }

    public static enum CompareOp {
        LESS,
        LESS_OR_EQUAL,
        EQUAL,
        NOT_EQUAL,
        GREATER_OR_EQUAL,
        GREATER,
        NO_OP;

    }
}

