/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.AbstractMessageLite;
import org.hbase.async.BatchableRpc;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseRpc;
import org.hbase.async.KeyValue;
import org.hbase.async.RegionInfo;
import org.hbase.async.RowLock;
import org.hbase.async.generated.ClientPB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class PutRequest
extends BatchableRpc
implements HBaseRpc.HasTable,
HBaseRpc.HasKey,
HBaseRpc.HasFamily,
HBaseRpc.HasQualifiers,
HBaseRpc.HasValues,
HBaseRpc.IsEdit,
HBaseRpc.HasQualifier,
HBaseRpc.HasValue {
    private static final byte[] PUT = new byte[]{112, 117, 116};
    static final byte CODE = 35;
    static final PutRequest EMPTY_PUT;
    private final byte[][][] qualifiers;
    private final byte[][][] values;
    private final long[][] timestamps;

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value) {
        this(table, key, family, qualifier, value, Long.MAX_VALUE, -1L);
    }

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, byte[][] values) {
        this(table, key, new byte[][]{family}, new byte[][][]{qualifiers}, new byte[][][]{values}, null, Long.MAX_VALUE, -1L);
    }

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, byte[][] values, long[] timestamps) {
        this(table, key, new byte[][]{family}, new byte[][][]{qualifiers}, new byte[][][]{values}, new long[][]{timestamps}, Long.MAX_VALUE, -1L);
    }

    public PutRequest(byte[] table, byte[] key, byte[][] families, byte[][][] qualifiers, byte[][][] values) {
        this(table, key, families, qualifiers, values, null, Long.MAX_VALUE, -1L);
    }

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value, long timestamp) {
        this(table, key, family, qualifier, value, timestamp, -1L);
    }

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, byte[][] values, long timestamp) {
        this(table, key, new byte[][]{family}, new byte[][][]{qualifiers}, new byte[][][]{values}, null, timestamp, -1L);
    }

    public PutRequest(byte[] table, byte[] key, byte[][] families, byte[][][] qualifiers, byte[][][] values, long timestamp) {
        this(table, key, families, qualifiers, values, null, timestamp, -1L);
    }

    public PutRequest(byte[] table, byte[] key, byte[][] families, byte[][][] qualifiers, byte[][][] values, long[][] timestamps) {
        this(table, key, families, qualifiers, values, timestamps, Long.MAX_VALUE, -1L);
    }

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value, RowLock lock) {
        this(table, key, family, qualifier, value, Long.MAX_VALUE, lock.id());
    }

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value, long timestamp, RowLock lock) {
        this(table, key, family, qualifier, value, timestamp, lock.id());
    }

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, byte[][] values, long timestamp, RowLock lock) {
        this(table, key, new byte[][]{family}, new byte[][][]{qualifiers}, new byte[][][]{values}, null, timestamp, lock.id());
    }

    public PutRequest(byte[] table, byte[] key, byte[][] families, byte[][][] qualifiers, byte[][][] values, long timestamp, RowLock lock) {
        this(table, key, families, qualifiers, values, null, timestamp, lock.id());
    }

    public PutRequest(byte[] table, byte[] key, byte[][] families, byte[][][] qualifiers, byte[][][] values, long[][] timestamps, RowLock lock) {
        this(table, key, families, qualifiers, values, timestamps, Long.MAX_VALUE, lock.id());
    }

    public PutRequest(String table, String key, String family, String qualifier, String value) {
        this(table.getBytes(), key.getBytes(), family.getBytes(), qualifier.getBytes(), value.getBytes(), Long.MAX_VALUE, -1L);
    }

    public PutRequest(String table, String key, String family, String qualifier, String value, RowLock lock) {
        this(table.getBytes(), key.getBytes(), family.getBytes(), qualifier.getBytes(), value.getBytes(), Long.MAX_VALUE, lock.id());
    }

    public PutRequest(byte[] table, KeyValue kv) {
        this(table, kv, -1L);
    }

    public PutRequest(byte[] table, KeyValue kv, RowLock lock) {
        this(table, kv, lock.id());
    }

    private PutRequest(byte[] table, KeyValue kv, long lockid) {
        this(table, kv.key(), kv.family(), kv.qualifier(), kv.value(), kv.timestamp(), lockid);
    }

    private PutRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value, long timestamp, long lockid) {
        this(table, key, new byte[][]{family}, new byte[][][]{new byte[][]{qualifier}}, new byte[][][]{new byte[][]{value}}, null, timestamp, lockid);
    }

    private PutRequest(byte[] table, byte[] key, byte[][] families, byte[][][] qualifiers, byte[][][] values, long[][] timestamps, long timestamp, long lockid) {
        super(table, key, families, timestamp, lockid);
        this.qualifiers = qualifiers;
        this.values = values;
        this.timestamps = timestamps;
    }

    private void checkParams(byte[][] families, byte[][][] qualifiers, byte[][][] values, long[][] timestamps) {
        if (families.length != qualifiers.length) {
            throw new IllegalArgumentException(String.format("Mismatch in number of families(%d) and qualifiers(%d) array size.", families.length, qualifiers.length));
        }
        if (families.length != values.length) {
            throw new IllegalArgumentException(String.format("Mismatch in number of families(%d) and values(%d) array size.", families.length, values.length));
        }
        if (timestamps != null && families.length != timestamps.length) {
            throw new IllegalArgumentException(String.format("Mismatch in number of families(%d) and timestamps(%d) array size.", families.length, timestamps.length));
        }
        for (int idx = 0; idx < families.length; ++idx) {
            KeyValue.checkFamily(families[idx]);
            if (qualifiers[idx] == null || qualifiers[idx].length == 0) {
                throw new IllegalArgumentException("No qualifiers are specifed for family " + families[idx] + " at index " + idx);
            }
            if (values[idx] == null || values[idx].length == 0) {
                throw new IllegalArgumentException("No values are specifed for family " + families[idx] + " at index " + idx);
            }
            if (qualifiers[idx].length != values[idx].length) {
                throw new IllegalArgumentException("Found " + qualifiers[idx].length + " qualifiers and " + values[idx].length + " values for family " + families[idx] + " at index " + idx + ". Should be equal.");
            }
            if (timestamps != null && qualifiers[idx].length != timestamps[idx].length) {
                throw new IllegalArgumentException("Found " + qualifiers[idx].length + " qualifiers and " + timestamps[idx].length + " timestamps for family " + families[idx] + " at index " + idx + ". Should be equal.");
            }
            for (int i = 0; i < qualifiers[idx].length; ++i) {
                KeyValue.checkQualifier(qualifiers[idx][i]);
                KeyValue.checkValue(values[idx][i]);
            }
        }
    }

    @Override
    byte[] method(byte server_version) {
        if (server_version >= 95) {
            return MUTATE;
        }
        return PUT;
    }

    @Override
    public byte[] table() {
        return this.table;
    }

    @Override
    public byte[] key() {
        return this.key;
    }

    @Override
    public byte[] qualifier() {
        return this.qualifiers[0][0];
    }

    @Override
    public byte[][] qualifiers() {
        return this.qualifiers[0];
    }

    @Override
    public byte[][][] getQualifiers() {
        return this.qualifiers;
    }

    @Override
    public byte[] value() {
        return this.values[0][0];
    }

    @Override
    public byte[][] values() {
        return this.values[0];
    }

    @Override
    public byte[][][] getValues() {
        return this.values;
    }

    public long[][] getTimestamps() {
        return this.timestamps;
    }

    @Override
    public String toString() {
        return super.toStringWithQualifiers("PutRequest", this.families, this.qualifiers, this.values, this.timestamps, ", timestamp=" + this.timestamp + ", lockid=" + this.lockid + ", durable=" + this.durable + ", bufferable=" + this.bufferable);
    }

    @Override
    byte version(byte server_version) {
        if (server_version >= 29) {
            return 2;
        }
        return 1;
    }

    @Override
    byte code() {
        return 35;
    }

    @Override
    int numKeyValues() {
        return this.qualifiers[0].length;
    }

    @Override
    int payloadSize() {
        return this.payloadSize(0);
    }

    int payloadSize(int idx) {
        int size = 0;
        for (int i = 0; i < this.qualifiers[idx].length; ++i) {
            size += KeyValue.predictSerializedSize(this.key, this.families[idx], this.qualifiers[idx][i], this.values[idx][i]);
        }
        return size;
    }

    @Override
    void serializePayload(ChannelBuffer buf) {
        this.serializePayload(buf, 0);
    }

    private void serializePayload(ChannelBuffer buf, int idx) {
        for (int i = 0; i < this.qualifiers[idx].length; ++i) {
            KeyValue.serialize(buf, (byte)4, this.timestamps == null ? this.timestamp : this.timestamps[idx][i], this.key, this.families[idx], this.qualifiers[idx][i], this.values[idx][i]);
        }
    }

    private int predictSerializedSize() {
        int size = 0;
        size += 4;
        ++size;
        size += 3;
        size += this.region.name().length;
        return size += this.predictPutSize();
    }

    int predictPutSize() {
        int size = 0;
        ++size;
        ++size;
        ++size;
        size += 3;
        size += this.key.length;
        size += 8;
        size += 8;
        ++size;
        size += 4;
        return size += this.payloadsSize();
    }

    @Override
    int payloadsSize() {
        int size = 0;
        for (int i = 0; i < this.families.length; ++i) {
            ++size;
            size += this.families[i].length;
            size += 4;
            size += 4;
            size += this.payloadSize(i);
        }
        return size;
    }

    @Override
    ClientPB.MutationProto toMutationProto() {
        ClientPB.MutationProto.Builder put = ClientPB.MutationProto.newBuilder().setRow(Bytes.wrap(this.key)).setMutateType(ClientPB.MutationProto.MutationType.PUT);
        if (!this.durable) {
            put.setDurability(ClientPB.MutationProto.Durability.SKIP_WAL);
        }
        ClientPB.MutationProto.ColumnValue.Builder columns = ClientPB.MutationProto.ColumnValue.newBuilder();
        for (int family_idx = 0; family_idx < this.families.length; ++family_idx) {
            columns.clear();
            columns.setFamily(Bytes.wrap(this.families[family_idx]));
            for (int i = 0; i < this.qualifiers[family_idx].length; ++i) {
                ClientPB.MutationProto.ColumnValue.QualifierValue column = ClientPB.MutationProto.ColumnValue.QualifierValue.newBuilder().setQualifier(Bytes.wrap(this.qualifiers[family_idx][i])).setValue(Bytes.wrap(this.values[family_idx][i])).setTimestamp(this.timestamps == null ? this.timestamp : this.timestamps[family_idx][i]).build();
                columns.addQualifierValue(column);
            }
            put.addColumnValue(columns);
        }
        return put.build();
    }

    @Override
    ChannelBuffer serialize(byte server_version) {
        if (server_version < 95) {
            return this.serializeOld(server_version);
        }
        ClientPB.MutateRequest req = ClientPB.MutateRequest.newBuilder().setRegion(this.region.toProtobuf()).setMutation(this.toMutationProto()).build();
        return PutRequest.toChannelBuffer(MUTATE, (AbstractMessageLite)req);
    }

    private ChannelBuffer serializeOld(byte server_version) {
        ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize());
        buf.writeInt(2);
        PutRequest.writeHBaseByteArray(buf, this.region.name());
        this.serializeInto(buf);
        return buf;
    }

    @Override
    Object deserialize(ChannelBuffer buf, int cell_size) {
        HBaseRpc.ensureNoCell(cell_size);
        ClientPB.MutateResponse resp = PutRequest.readProtobuf(buf, ClientPB.MutateResponse.PARSER);
        return null;
    }

    void serializeInto(ChannelBuffer buf) {
        buf.writeByte(35);
        buf.writeByte(35);
        buf.writeByte(1);
        PutRequest.writeByteArray(buf, this.key);
        buf.writeLong(this.timestamp);
        buf.writeLong(this.lockid);
        buf.writeByte(this.durable ? 1 : 0);
        buf.writeInt(this.families.length);
        this.serializePayloads(buf);
    }

    @Override
    void serializePayloads(ChannelBuffer buf) {
        for (int i = 0; i < this.families.length; ++i) {
            PutRequest.writeByteArray(buf, this.families[i]);
            buf.writeInt(this.qualifiers[i].length);
            buf.writeInt(this.payloadSize(i));
            this.serializePayload(buf, i);
        }
    }

    static {
        byte[] zero = new byte[]{0};
        byte[][] onezero = new byte[][]{zero};
        EMPTY_PUT = new PutRequest(zero, zero, zero, onezero, onezero);
        EMPTY_PUT.setRegion(new RegionInfo(zero, zero, zero));
    }
}

