/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.mapr.fs.MapRHTable;
import com.mapr.fs.jni.MapRCallBackQueue;
import com.mapr.fs.jni.MapRGet;
import com.mapr.fs.jni.MapRIncrement;
import com.mapr.fs.jni.MapRPut;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.jni.MapRRowConstraint;
import com.mapr.fs.jni.MapRScan;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.hbase.async.Bytes;
import org.hbase.async.GetRequest;
import org.hbase.async.KeyValue;
import org.hbase.async.MapRThreadPool;
import org.hbase.async.PutRequest;
import org.hbase.async.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRConverter {
    private static final Logger LOG = LoggerFactory.getLogger(MapRConverter.class);

    public static int compareTo(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
            return 0;
        }
        int end1 = offset1 + length1;
        int end2 = offset2 + length2;
        int i = offset1;
        for (int j = offset2; i < end1 && j < end2; ++i, ++j) {
            int a = buffer1[i] & 0xFF;
            int b = buffer2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return length1 - length2;
    }

    public static MapRPut toMapRPut(PutRequest put, MapRHTable mtable, String family, MapRThreadPool cbq) {
        int id = 0;
        int ncells = put.qualifiers().length;
        try {
            id = mtable.getFamilyId(family);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Invalid column family " + family, ioe);
        }
        if (ncells > 1) {
            Integer[] cells = new Integer[ncells];
            for (int i = 0; i < ncells; ++i) {
                cells[i] = i;
            }
            final byte[][] quals = put.qualifiers();
            byte[][] vals = put.values();
            Comparator<Integer> cmp = new Comparator<Integer>(){

                @Override
                public int compare(Integer i, Integer j) {
                    return MapRConverter.compareTo(quals[i], 0, quals[i].length, quals[j], 0, quals[j].length);
                }
            };
            Arrays.sort(cells, cmp);
            byte[][] sortedQuals = new byte[ncells][];
            byte[][] sortedVals = new byte[ncells][];
            for (int i = 0; i < ncells; ++i) {
                int off = cells[i];
                sortedQuals[i] = quals[off];
                sortedVals[i] = vals[off];
            }
            return new MapRPut(put.key(), id, (byte[][])sortedQuals, (byte[][])sortedVals, put.timestamp(), (Object)put, (MapRCallBackQueue)cbq);
        }
        return new MapRPut(put.key(), id, put.qualifiers(), put.values(), put.timestamp(), (Object)put, (MapRCallBackQueue)cbq);
    }

    public static MapRGet toMapRGet(GetRequest get, MapRHTable mtable, String family) {
        try {
            MapRGet mrget = new MapRGet();
            mrget.key = get.key();
            mrget.result = new MapRResult();
            mrget.rowConstraint = MapRConverter.toRowConstraint(mtable, family, get.qualifiers());
            return mrget;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Invalid column family " + family, ioe);
        }
    }

    public static MapRRowConstraint toRowConstraint(MapRHTable htable, String family, byte[][] qualifier) throws IOException {
        MapRRowConstraint rc = new MapRRowConstraint();
        if (family != null) {
            int id = 0;
            try {
                id = htable.getFamilyId(family);
            }
            catch (IOException ioe) {
                throw new IOException("Invalid column family " + family, ioe);
            }
            rc.numFamilies = 1;
            rc.families = new int[rc.numFamilies];
            rc.families[0] = id;
            rc.columnsPerFamily = new int[rc.numFamilies];
        } else {
            rc.numFamilies = 0;
            rc.families = new int[rc.numFamilies];
            rc.columnsPerFamily = new int[rc.numFamilies];
        }
        if (qualifier != null) {
            rc.columns = new byte[qualifier.length][];
            rc.numColumns = qualifier.length;
            if (family != null) {
                rc.columnsPerFamily[0] = qualifier.length;
            }
            int i = 0;
            for (byte[] q : qualifier) {
                rc.columns[i] = q;
                ++i;
            }
        } else {
            rc.numColumns = 0;
            if (family != null) {
                rc.columnsPerFamily[0] = 0;
            }
        }
        rc.maxVersions = 1;
        rc.minStamp = 0L;
        rc.maxStamp = Long.MAX_VALUE;
        return rc;
    }

    public static ArrayList<KeyValue> toAsyncHBaseResult(MapRResult mresult, byte[] key, MapRHTable htable) {
        if (mresult == null || mresult.getColumnOffsets() == null || mresult.getBufSize() == 0) {
            return new ArrayList<KeyValue>();
        }
        ArrayList<KeyValue> cells = new ArrayList<KeyValue>(mresult.getColumnOffsets().length);
        ByteBuffer bbuf = mresult.getByteBuf();
        int cellPos = 0;
        for (int f = 0; f < mresult.getCfids().length; ++f) {
            String cfname;
            try {
                cfname = htable.getFamilyName(mresult.getCfids()[f]);
            }
            catch (IOException ioe) {
                if (key != null) {
                    LOG.error("Stale column family id: " + mresult.getCfids()[f] + ". Ignoring get request with key = " + Bytes.toString(key) + "]");
                    continue;
                }
                LOG.error("Stale column family id: " + mresult.getCfids()[f] + ", during scan");
                continue;
            }
            byte[] fname = cfname.getBytes();
            for (int i = 0; i < mresult.getCellsPerFamily()[f]; ++i) {
                int length = mresult.getColumnLengths()[cellPos];
                byte[] qual = null;
                if (length != 0) {
                    qual = new byte[length];
                    bbuf.position(mresult.getColumnOffsets()[cellPos]);
                    bbuf.get(qual, 0, length);
                }
                length = mresult.getValueLengths()[cellPos];
                byte[] val = new byte[length];
                bbuf.position(mresult.getValueOffsets()[cellPos]);
                bbuf.get(val, 0, length);
                KeyValue kv = new KeyValue(key, fname, qual, mresult.getTimeStamps()[cellPos], val);
                cells.add(kv);
                ++cellPos;
            }
        }
        return cells;
    }

    public static MapRScan toMapRScan(Scanner scan, MapRHTable mtable) throws IOException {
        MapRScan maprscan = new MapRScan();
        maprscan.startRow = scan.getCurrentKey();
        maprscan.stopRow = scan.getStopKey();
        maprscan.rowConstraint = MapRConverter.toRowConstraint(mtable, Bytes.toString(scan.getFamily()), scan.getQualifiers(), scan.getMinTimestamp(), scan.getMaxTimestamp());
        return maprscan;
    }

    public static MapRRowConstraint toRowConstraint(MapRHTable mtable, String family, byte[][] qualifiers, long minTimeStamp, long maxTimeStamp) throws IOException {
        MapRRowConstraint rc = new MapRRowConstraint();
        if (family != null) {
            int id = 0;
            try {
                id = mtable.getFamilyId(family);
            }
            catch (IOException ioe) {
                throw new IOException("Invalid column family " + family, ioe);
            }
            rc.numFamilies = 1;
            rc.families = new int[rc.numFamilies];
            rc.families[0] = id;
            rc.columnsPerFamily = new int[rc.numFamilies];
            rc.columnsPerFamily[0] = 1;
        } else {
            rc.numFamilies = 0;
            rc.families = new int[rc.numFamilies];
            rc.columnsPerFamily = new int[rc.numFamilies];
        }
        if (qualifiers != null) {
            rc.numColumns = qualifiers.length;
            rc.columns = new byte[rc.numColumns][];
            if (family != null) {
                rc.columnsPerFamily[0] = rc.numColumns;
            }
            int i = 0;
            for (byte[] q : qualifiers) {
                rc.columns[i] = q;
                ++i;
            }
        } else {
            rc.numColumns = 0;
            if (family != null) {
                rc.columnsPerFamily[0] = 0;
            }
        }
        rc.maxVersions = 1;
        rc.minStamp = minTimeStamp;
        rc.maxStamp = maxTimeStamp;
        return rc;
    }

    public static MapRIncrement toMapRIncrement(byte[] key, byte[] family, byte[] qualifier, long delta, MapRHTable mtable) throws IOException {
        MapRIncrement mincr = new MapRIncrement();
        mincr.key = key;
        mincr.rowConstraint = MapRConverter.toRowConstraint(mtable, Bytes.toString(family), new byte[][]{qualifier}, 0L, Long.MAX_VALUE);
        mincr.deltas = new long[1];
        mincr.deltas[0] = delta;
        return mincr;
    }
}

