/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.ByteString;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.MapRResultScanner;
import com.mapr.fs.jni.MapRScan;
import com.mapr.fs.proto.Dbfilters;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseRpc;
import org.hbase.async.InvalidResponseException;
import org.hbase.async.KeyValue;
import org.hbase.async.MapRThreadPool;
import org.hbase.async.NotServingRegionException;
import org.hbase.async.RegionInfo;
import org.hbase.async.UnknownScannerException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Scanner {
    private static final Logger LOG = LoggerFactory.getLogger(Scanner.class);
    public static final int DEFAULT_MAX_NUM_KVS = 4096;
    public static final int DEFAULT_MAX_NUM_ROWS = 128;
    private static final RegionInfo DONE = new RegionInfo(HBaseClient.EMPTY_ARRAY, HBaseClient.EMPTY_ARRAY, HBaseClient.EMPTY_ARRAY);
    private final HBaseClient client;
    private final byte[] table;
    private byte[] start_key = HBaseClient.EMPTY_ARRAY;
    private byte[] stop_key = HBaseClient.EMPTY_ARRAY;
    private byte[] family;
    private byte[][] qualifiers;
    private byte[] filter;
    private long min_timestamp = 0L;
    private long max_timestamp = Long.MAX_VALUE;
    private boolean populate_blockcache = true;
    private int max_num_rows = 128;
    private int max_num_kvs = 4096;
    private int versions = 1;
    private RegionInfo region;
    private long scanner_id;
    private GetNextRowsRequest get_next_rows_request;
    private boolean isMapRTable;
    private Dbfilters.FilterMsg filterMsg;
    private Exception filterException;
    public MapRResultScanner mresultScanner;
    public MapRHTable mTable;
    public MapRScan mscan;
    public MapRThreadPool mpool;
    private static final byte[] ROWFILTER = Bytes.ISO88591("org.apache.hadoop.hbase.filter.RowFilter");
    private static final byte[] REGEXSTRINGCOMPARATOR = Bytes.ISO88591("org.apache.hadoop.hbase.filter.RegexStringComparator");
    private static final byte[] EQUAL = new byte[]{69, 81, 85, 65, 76};
    private static final int kRegexStringComparator = -489178560;
    private static final int kRowFilter = 1184742660;
    private final Callback<Object, Object> got_next_row = new Callback<Object, Object>(){

        public Object call(Object response) {
            if (response == null) {
                if (Scanner.this.isMapRTable) {
                    Scanner.access$402(Scanner.this, Scanner.access$502(Scanner.this, HBaseClient.EMPTY_ARRAY));
                    return null;
                }
                byte[] region_stop_key = Scanner.this.region.stopKey();
                if (region_stop_key == HBaseClient.EMPTY_ARRAY || Scanner.this.stop_key != HBaseClient.EMPTY_ARRAY && Bytes.memcmp(Scanner.this.stop_key, region_stop_key) <= 0) {
                    Scanner.this.get_next_rows_request = null;
                    Scanner.access$702(Scanner.this, null);
                    Scanner.access$802(Scanner.this, null);
                    Scanner.access$402(Scanner.this, Scanner.access$502(Scanner.this, HBaseClient.EMPTY_ARRAY));
                    return Scanner.this.close().addCallback((Callback)new Callback<ArrayList<ArrayList<KeyValue>>, Object>(){

                        public ArrayList<ArrayList<KeyValue>> call(Object arg) {
                            return null;
                        }

                        public String toString() {
                            return "auto-close scanner " + Bytes.hex(Scanner.this.scanner_id);
                        }
                    });
                }
                return Scanner.this.continueScanOnNextRegion();
            }
            if (!(response instanceof ArrayList)) {
                throw new InvalidResponseException(ArrayList.class, response);
            }
            ArrayList rows = (ArrayList)response;
            ArrayList lastrow = (ArrayList)rows.get(rows.size() - 1);
            Scanner.access$402(Scanner.this, ((KeyValue)lastrow.get(0)).key());
            if (Scanner.this.isMapRTable && rows.size() == 0) {
                Scanner.access$402(Scanner.this, Scanner.access$502(Scanner.this, HBaseClient.EMPTY_ARRAY));
                return null;
            }
            return rows;
        }

        public String toString() {
            return "get nextRows response";
        }
    };
    private static final byte[] OPEN_SCANNER = new byte[]{111, 112, 101, 110, 83, 99, 97, 110, 110, 101, 114};
    private static final byte[] NEXT = new byte[]{110, 101, 120, 116};

    Scanner(HBaseClient client, byte[] table, MapRHTable mTable, MapRThreadPool mpool) {
        boolean bl = this.isMapRTable = mTable != null;
        if (!this.isMapRTable) {
            KeyValue.checkTable(table);
        }
        this.client = client;
        this.table = table;
        this.mresultScanner = null;
        this.filterMsg = null;
        this.filterException = null;
        this.mTable = mTable;
        this.mscan = null;
        this.mpool = mpool;
    }

    Scanner(HBaseClient client, byte[] table, MapRThreadPool mpool) {
        this(client, table, null, mpool);
    }

    public MapRResultScanner getMapRResultScanner() {
        return this.mresultScanner;
    }

    public byte[] getCurrentKey() {
        return this.start_key;
    }

    public byte[] getStopKey() {
        return this.stop_key;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public byte[][] getQualifiers() {
        return this.qualifiers;
    }

    public byte[] getFilter() {
        return this.filter;
    }

    public int getMaxNumRows() {
        return this.max_num_rows;
    }

    public Dbfilters.FilterMsg getFilterMsg() {
        return this.filterMsg;
    }

    public void setStartKey(byte[] start_key) {
        KeyValue.checkKey(start_key);
        this.checkScanningNotStarted();
        this.start_key = start_key;
    }

    public void setStartKey(String start_key) {
        this.setStartKey(start_key.getBytes());
    }

    public void setStopKey(byte[] stop_key) {
        KeyValue.checkKey(stop_key);
        this.checkScanningNotStarted();
        this.stop_key = stop_key;
    }

    public void setStopKey(String stop_key) {
        this.setStopKey(stop_key.getBytes());
    }

    public void setFamily(byte[] family) {
        KeyValue.checkFamily(family);
        this.checkScanningNotStarted();
        this.family = family;
    }

    public void setFamily(String family) {
        this.setFamily(family.getBytes());
    }

    public void setQualifier(byte[] qualifier) {
        KeyValue.checkQualifier(qualifier);
        this.checkScanningNotStarted();
        this.qualifiers = new byte[][]{qualifier};
    }

    public void setQualifier(String qualifier) {
        this.setQualifier(qualifier.getBytes());
    }

    public void setQualifiers(byte[][] qualifiers) {
        this.checkScanningNotStarted();
        for (byte[] qualifier : qualifiers) {
            KeyValue.checkQualifier(qualifier);
        }
        this.qualifiers = qualifiers;
    }

    public void setKeyRegexp(String regexp) {
        this.setKeyRegexp(regexp, CharsetUtil.ISO_8859_1);
    }

    private static String getFilterId(int hashCode) {
        return String.format("%08x", hashCode);
    }

    private String handleNullByteInFilter(String regexp, Charset charset) {
        if (charset == null || charset.compareTo(CharsetUtil.ISO_8859_1) == 0) {
            byte[] reg = regexp.getBytes(charset);
            StringBuilder buf = new StringBuilder();
            for (byte b : reg) {
                if (b == 0) {
                    buf.append("\\E\\000\\Q");
                    continue;
                }
                buf.append((char)(b & 0xFF));
            }
            return buf.toString();
        }
        return regexp;
    }

    public void setKeyRegexp(String regexp, Charset charset) {
        if (this.isMapRTable) {
            String regex = this.handleNullByteInFilter(regexp, charset);
            try {
                Dbfilters.RegexStringComparatorProto rcp = Dbfilters.RegexStringComparatorProto.newBuilder().setPattern(ByteString.copyFrom((byte[])regex.getBytes(charset))).setIsUTF8(charset.equals(CharsetUtil.UTF_8)).build();
                Dbfilters.ComparatorProto cp = Dbfilters.ComparatorProto.newBuilder().setName(Scanner.getFilterId(-489178560)).setSerializedComparator(rcp.toByteString()).build();
                Dbfilters.FilterComparatorProto.Builder fcp = Dbfilters.FilterComparatorProto.newBuilder().setCompareOp(Dbfilters.CompareOpProto.EQUAL).setComparator(cp);
                ByteString state = Dbfilters.RowFilterProto.newBuilder().setFilterComparator(fcp).build().toByteString();
                this.filterMsg = Dbfilters.FilterMsg.newBuilder().setId(Scanner.getFilterId(1184742660)).setSerializedState(state).build();
            }
            catch (Exception e) {
                this.filterException = e;
            }
        } else {
            byte[] regex = Bytes.UTF8(regexp);
            byte[] chars = Bytes.UTF8(charset.name());
            this.filter = new byte[105 + regex.length + 2 + chars.length];
            ChannelBuffer buf = ChannelBuffers.wrappedBuffer((byte[])this.filter);
            buf.clear();
            buf.writeByte((int)((byte)ROWFILTER.length));
            buf.writeBytes(ROWFILTER);
            buf.writeShort(5);
            buf.writeBytes(EQUAL);
            buf.writeByte(54);
            buf.writeByte(0);
            buf.writeByte((int)((byte)REGEXSTRINGCOMPARATOR.length));
            buf.writeBytes(REGEXSTRINGCOMPARATOR);
            buf.writeShort(regex.length);
            buf.writeBytes(regex);
            buf.writeShort(chars.length);
            buf.writeBytes(chars);
        }
    }

    public void setServerBlockCache(boolean populate_blockcache) {
        this.checkScanningNotStarted();
        this.populate_blockcache = populate_blockcache;
    }

    public void setMaxNumRows(int max_num_rows) {
        if (max_num_rows <= 0) {
            throw new IllegalArgumentException("zero or negative argument: " + max_num_rows);
        }
        this.max_num_rows = max_num_rows;
    }

    public void setMaxNumKeyValues(int max_num_kvs) {
        if (max_num_kvs == 0) {
            throw new IllegalArgumentException("batch size can't be zero");
        }
        this.checkScanningNotStarted();
        this.max_num_kvs = max_num_kvs;
    }

    public void setMaxVersions(int versions) {
        if (versions <= 0) {
            throw new IllegalArgumentException("Need a strictly positive number: " + versions);
        }
        this.checkScanningNotStarted();
        this.versions = versions;
    }

    public int getMaxVersions() {
        return this.versions;
    }

    public void setMinTimestamp(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Negative timestamp: " + timestamp);
        }
        if (timestamp > this.max_timestamp) {
            throw new IllegalArgumentException("New minimum timestamp (" + timestamp + ") is greater than the maximum" + " timestamp: " + this.max_timestamp);
        }
        this.checkScanningNotStarted();
        this.min_timestamp = timestamp;
    }

    public long getMinTimestamp() {
        return this.min_timestamp;
    }

    public void setMaxTimestamp(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Negative timestamp: " + timestamp);
        }
        if (timestamp < this.min_timestamp) {
            throw new IllegalArgumentException("New maximum timestamp (" + timestamp + ") is greater than the minimum" + " timestamp: " + this.min_timestamp);
        }
        this.checkScanningNotStarted();
        this.max_timestamp = timestamp;
    }

    public long getMaxTimestamp() {
        return this.max_timestamp;
    }

    public void setTimeRange(long min_timestamp, long max_timestamp) {
        if (min_timestamp > max_timestamp) {
            throw new IllegalArgumentException("New minimum timestamp (" + min_timestamp + ") is greater than the new maximum" + " timestamp: " + max_timestamp);
        }
        if (min_timestamp < 0L) {
            throw new IllegalArgumentException("Negative minimum timestamp: " + min_timestamp);
        }
        this.checkScanningNotStarted();
        this.min_timestamp = min_timestamp;
        this.max_timestamp = max_timestamp;
    }

    public Deferred<ArrayList<ArrayList<KeyValue>>> nextRows(int nrows) {
        this.setMaxNumRows(nrows);
        return this.nextRows();
    }

    public Deferred<ArrayList<ArrayList<KeyValue>>> nextRows() {
        if (this.isMapRTable) {
            if (this.filterException != null) {
                return Deferred.fromError((Exception)this.filterException);
            }
            GetNextRowsRequest dummyRpc = new GetNextRowsRequest();
            Deferred d = dummyRpc.getDeferred().addCallbacks(this.got_next_row, this.nextRowErrback());
            this.mpool.addRequest(dummyRpc, this, this.mpool);
            return d;
        }
        if (this.region == DONE) {
            return Deferred.fromResult(null);
        }
        if (this.region == null) {
            return this.client.openScanner(this).addCallbackDeferring((Callback)new Callback<Deferred<ArrayList<ArrayList<KeyValue>>>, Long>(){

                public Deferred<ArrayList<ArrayList<KeyValue>>> call(Long arg) {
                    Scanner.this.scanner_id = arg;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Scanner " + Bytes.hex(arg) + " opened on " + Scanner.this.region);
                    }
                    return Scanner.this.nextRows();
                }

                public String toString() {
                    return "scanner opened";
                }
            });
        }
        Deferred d = this.client.scanNextRows(this).addCallbacks(this.got_next_row, this.nextRowErrback());
        return d;
    }

    private final Callback<Object, Object> nextRowErrback() {
        return new Callback<Object, Object>(){

            public Object call(Object error) {
                RegionInfo old_region = Scanner.this.region;
                Scanner.this.invalidate();
                if (error instanceof NotServingRegionException) {
                    Scanner.access$402(Scanner.this, Arrays.copyOf(Scanner.this.start_key, Scanner.this.start_key.length + 1));
                    return Scanner.this.nextRows();
                }
                if (error instanceof UnknownScannerException) {
                    Scanner scnr = Scanner.this;
                    LOG.warn(old_region + " pretends to not know " + scnr + ".  I will" + " retry to open a scanner but this is typically because you've" + " been holding the scanner open and idle for too long (possibly" + " due to a long GC pause on your side or in the RegionServer)", error);
                    return Scanner.this.nextRows();
                }
                return error;
            }

            public String toString() {
                return "NextRow errback";
            }
        };
    }

    public Deferred<Object> close() {
        if (!(this.isMapRTable || this.region != null && this.region != DONE)) {
            return Deferred.fromResult(null);
        }
        return this.client.closeScanner(this).addBoth(this.closedCallback());
    }

    private Callback<Object, Object> closedCallback() {
        return new Callback<Object, Object>(){

            public Object call(Object arg) {
                if (arg instanceof Exception) {
                    Exception error = (Exception)arg;
                    if (error instanceof NotServingRegionException || error instanceof UnknownScannerException) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Ignoring exception when closing " + Scanner.this, (Throwable)error);
                        }
                        arg = null;
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanner " + Bytes.hex(Scanner.this.scanner_id) + " closed on " + Scanner.this.region);
                }
                Scanner.this.region = DONE;
                Scanner.this.scanner_id = -2401262971557716307L;
                return arg;
            }

            public String toString() {
                return "scanner closed";
            }
        };
    }

    private Deferred<ArrayList<ArrayList<KeyValue>>> continueScanOnNextRegion() {
        final long old_scanner_id = this.scanner_id;
        final RegionInfo old_region = this.region;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanner " + Bytes.hex(old_scanner_id) + " done scanning " + old_region);
        }
        this.client.closeScanner(this).addCallback((Callback)new Callback<Object, Object>(){

            public Object call(Object arg) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanner " + Bytes.hex(old_scanner_id) + " closed on " + old_region);
                }
                return arg;
            }

            public String toString() {
                return "scanner moved";
            }
        });
        this.start_key = this.region.stopKey();
        this.scanner_id = -2401262980684521811L;
        this.invalidate();
        return this.nextRows();
    }

    public String toString() {
        String region = this.region == null ? "null" : (this.region == DONE ? "none" : this.region.toString());
        int qual_length = 0;
        if (this.qualifiers == null) {
            qual_length = 4;
        } else {
            for (byte[] qualifier : this.qualifiers) {
                qual_length += qualifier.length + 2;
            }
        }
        StringBuilder buf = new StringBuilder(15 + this.table.length + 1 + 12 + 1 + this.start_key.length + 1 + 1 + this.stop_key.length + 1 + 9 + 1 + (this.family == null ? 4 : this.family.length) + 1 + 13 + 1 + qual_length + 1 + 22 + 5 + 15 + 5 + 14 + 6 + 14 + 1 + region.length() + 1 + 13 + 18 + 1);
        buf.append("Scanner(table=");
        Bytes.pretty(buf, this.table);
        buf.append(", start_key=");
        Bytes.pretty(buf, this.start_key);
        buf.append(", stop_key=");
        Bytes.pretty(buf, this.stop_key);
        buf.append(", family=");
        Bytes.pretty(buf, this.family);
        buf.append(", qualifiers=");
        Bytes.pretty(buf, this.qualifiers);
        buf.append(", populate_blockcache=").append(this.populate_blockcache).append(", max_num_rows=").append(this.max_num_rows).append(", max_num_kvs=").append(this.max_num_kvs).append(", region=").append(region);
        buf.append(", scanner_id=").append(Bytes.hex(this.scanner_id)).append(')');
        String mrsStr = this.mresultScanner == null ? "null" : this.mresultScanner.toString();
        buf.append(", mresultScanner=").append(mrsStr);
        return buf.toString();
    }

    byte[] table() {
        return this.table;
    }

    byte[] startKey() {
        return this.start_key;
    }

    void setRegionName(RegionInfo region) {
        this.region = region;
    }

    void invalidate() {
        this.region = null;
    }

    RegionInfo currentRegion() {
        return this.region;
    }

    HBaseRpc getNextRowsRequest() {
        if (this.get_next_rows_request == null) {
            this.get_next_rows_request = new GetNextRowsRequest();
        }
        return this.get_next_rows_request;
    }

    HBaseRpc getOpenRequest() {
        return new OpenScannerRequest();
    }

    HBaseRpc getCloseRequest() {
        return new CloseScannerRequest(this.scanner_id);
    }

    private void checkScanningNotStarted() {
        if (this.region != null) {
            throw new IllegalStateException("scanning already started");
        }
    }

    static /* synthetic */ byte[] access$402(Scanner x0, byte[] x1) {
        x0.start_key = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$502(Scanner x0, byte[] x1) {
        x0.stop_key = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$702(Scanner x0, byte[] x1) {
        x0.family = x1;
        return x1;
    }

    static /* synthetic */ byte[][] access$802(Scanner x0, byte[][] x1) {
        x0.qualifiers = x1;
        return x1;
    }

    private static final class CloseScannerRequest
    extends HBaseRpc {
        private static final byte[] CLOSE = new byte[]{99, 108, 111, 115, 101};
        private final long scanner_id;

        public CloseScannerRequest(long scanner_id) {
            super(CLOSE);
            this.scanner_id = scanner_id;
        }

        @Override
        ChannelBuffer serialize(byte server_version) {
            ChannelBuffer buf = this.newBuffer(server_version, 13);
            buf.writeInt(1);
            CloseScannerRequest.writeHBaseLong(buf, this.scanner_id);
            return buf;
        }

        @Override
        public String toString() {
            return "CloseScannerRequest(scanner_id=" + this.scanner_id + ", attempt=" + this.attempt + ')';
        }
    }

    private final class GetNextRowsRequest
    extends HBaseRpc {
        public GetNextRowsRequest() {
            super(NEXT);
        }

        @Override
        ChannelBuffer serialize(byte server_version) {
            ChannelBuffer buf = this.newBuffer(server_version, 18);
            buf.writeInt(2);
            GetNextRowsRequest.writeHBaseLong(buf, Scanner.this.scanner_id);
            GetNextRowsRequest.writeHBaseInt(buf, Scanner.this.max_num_rows);
            return buf;
        }

        @Override
        public String toString() {
            return "GetNextRowsRequest(scanner_id=" + Scanner.this.scanner_id + ", max_num_rows=" + Scanner.this.max_num_rows + ", region=" + this.region + ", attempt=" + this.attempt + ')';
        }
    }

    private final class OpenScannerRequest
    extends HBaseRpc {
        public OpenScannerRequest() {
            super(OPEN_SCANNER, Scanner.this.table, Scanner.this.start_key);
        }

        private int predictSerializedSize() {
            int size = 0;
            size += 4;
            ++size;
            size += 3;
            size += this.region.name().length;
            ++size;
            ++size;
            ++size;
            size += 3;
            size += Scanner.this.start_key.length;
            size += 3;
            size += Scanner.this.stop_key.length;
            size += 4;
            size += 4;
            size += 4;
            ++size;
            ++size;
            if (Scanner.this.filter != null) {
                size += Scanner.this.filter.length;
            }
            size += 8;
            size += 8;
            ++size;
            size += 4;
            if (Scanner.this.family != null) {
                ++size;
                size += Scanner.this.family.length;
                size += 4;
                if (Scanner.this.qualifiers != null) {
                    for (byte[] qualifier : Scanner.this.qualifiers) {
                        size += 3;
                        size += qualifier.length;
                    }
                }
            }
            return size;
        }

        @Override
        ChannelBuffer serialize(byte server_version) {
            ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize());
            buf.writeInt(2);
            OpenScannerRequest.writeHBaseByteArray(buf, this.region.name());
            buf.writeByte(39);
            buf.writeByte(39);
            buf.writeByte(1);
            OpenScannerRequest.writeByteArray(buf, Scanner.this.start_key);
            OpenScannerRequest.writeByteArray(buf, Scanner.this.stop_key);
            buf.writeInt(Scanner.this.versions);
            buf.writeInt(Scanner.this.max_num_kvs);
            buf.writeInt(-559039906);
            buf.writeByte(Scanner.this.populate_blockcache ? 1 : 0);
            if (Scanner.this.filter == null) {
                buf.writeByte(0);
            } else {
                buf.writeByte(1);
                buf.writeBytes(Scanner.this.filter);
            }
            buf.writeLong(Scanner.this.min_timestamp);
            buf.writeLong(Scanner.this.max_timestamp);
            buf.writeByte(Scanner.this.min_timestamp != 0L || Scanner.this.max_timestamp != Long.MAX_VALUE ? 0 : 1);
            buf.writeInt(Scanner.this.family != null ? 1 : 0);
            if (Scanner.this.family != null) {
                OpenScannerRequest.writeByteArray(buf, Scanner.this.family);
                buf.writeInt(Scanner.this.qualifiers == null ? 0 : Scanner.this.qualifiers.length);
                if (Scanner.this.qualifiers != null) {
                    for (byte[] qualifier : Scanner.this.qualifiers) {
                        OpenScannerRequest.writeByteArray(buf, qualifier);
                    }
                }
            }
            Scanner.this.region = this.region;
            return buf;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(12 + Scanner.this.start_key.length + 2 + 11 + Scanner.this.stop_key.length + 2 + 14 + 4 + 22 + 5);
            buf.append(", start_key=");
            Bytes.pretty(buf, Scanner.this.start_key);
            buf.append(", stop_key=");
            Bytes.pretty(buf, Scanner.this.stop_key);
            buf.append(", max_num_kvs=").append(Scanner.this.max_num_kvs).append(", populate_blockcache=").append(Scanner.this.populate_blockcache);
            return super.toStringWithQualifiers("OpenScannerRequest", Scanner.this.family, Scanner.this.qualifiers, null, buf.toString());
        }
    }
}

