/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.zookeeper;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.ClusterActionHandlerSupport;
import org.apache.whirr.service.FirewallManager;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperClusterActionHandler
extends ClusterActionHandlerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperClusterActionHandler.class);
    public static final String ZOOKEEPER_ROLE = "zookeeper";
    private static final int CLIENT_PORT = 2181;

    public String getRole() {
        return ZOOKEEPER_ROLE;
    }

    protected Configuration getConfiguration(ClusterSpec spec) throws IOException {
        return this.getConfiguration(spec, "whirr-zookeeper-default.properties");
    }

    protected void beforeBootstrap(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Configuration config = this.getConfiguration(clusterSpec);
        ZooKeeperClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        ZooKeeperClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_tarball", (String[])new String[0]));
        ZooKeeperClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_service", (String[])new String[0]));
        ZooKeeperClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getInstallFunction(config, "java", "install_openjdk"), (String[])new String[0]));
        String tarurl = config.getString("whirr.zookeeper.tarball.url");
        ZooKeeperClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getInstallFunction(config), (String[])new String[]{"-u", ZooKeeperClusterActionHandler.prepareRemoteFileUrl((ClusterActionEvent)event, (String)tarurl)}));
    }

    protected void beforeConfigure(ClusterActionEvent event) throws IOException, InterruptedException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        event.getFirewallManager().addRule(FirewallManager.Rule.create().destination(RolePredicates.role((String)ZOOKEEPER_ROLE)).port(2181));
        Set ensemble = cluster.getInstancesMatching(RolePredicates.role((String)ZOOKEEPER_ROLE));
        String servers = Joiner.on((char)' ').join(this.getPrivateIps(ensemble));
        Configuration config = this.getConfiguration(clusterSpec);
        ZooKeeperClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        ZooKeeperClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getConfigureFunction(config), (String[])new String[]{servers}));
    }

    protected void afterConfigure(ClusterActionEvent event) {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        LOG.info("Completed configuration of {}", (Object)clusterSpec.getClusterName());
        String hosts = Joiner.on((char)',').join(ZooKeeperClusterActionHandler.getHosts(cluster.getInstancesMatching(RolePredicates.role((String)ZOOKEEPER_ROLE))));
        LOG.info("Hosts: {}", (Object)hosts);
    }

    protected void beforeStart(ClusterActionEvent event) throws IOException {
        Configuration config = this.getConfiguration(event.getClusterSpec());
        String configureFunction = this.getConfigureFunction(config);
        if (configureFunction.equals("configure_zookeeper")) {
            ZooKeeperClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getStartFunction(config), (String[])new String[0]));
        }
    }

    protected void beforeStop(ClusterActionEvent event) throws IOException {
        ZooKeeperClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getStopFunction(this.getConfiguration(event.getClusterSpec())), (String[])new String[0]));
    }

    protected void beforeCleanup(ClusterActionEvent event) throws IOException {
        ZooKeeperClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"remove_service", (String[])new String[0]));
        ZooKeeperClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getCleanupFunction(this.getConfiguration(event.getClusterSpec())), (String[])new String[0]));
    }

    protected String getInstallFunction(Configuration config) {
        return this.getInstallFunction(config, this.getRole(), "install_" + this.getRole());
    }

    protected String getConfigureFunction(Configuration config) {
        return this.getConfigureFunction(config, this.getRole(), "configure_" + this.getRole());
    }

    protected String getStartFunction(Configuration config) {
        return this.getStartFunction(config, this.getRole(), "start_" + this.getRole());
    }

    protected String getStopFunction(Configuration config) {
        return this.getStopFunction(config, this.getRole(), "stop_" + this.getRole());
    }

    protected String getCleanupFunction(Configuration config) {
        return this.getCleanupFunction(config, this.getRole(), "cleanup_" + this.getRole());
    }

    private List<String> getPrivateIps(Set<Cluster.Instance> instances) {
        return Lists.transform((List)Lists.newArrayList(instances), (Function)new Function<Cluster.Instance, String>(){

            public String apply(Cluster.Instance instance) {
                return instance.getPrivateIp();
            }
        });
    }

    static List<String> getHosts(Set<Cluster.Instance> instances) {
        return ZooKeeperClusterActionHandler.getHosts(instances, false);
    }

    static List<String> getHosts(Set<Cluster.Instance> instances, final boolean internalHost) {
        return Lists.transform((List)Lists.newArrayList(instances), (Function)new Function<Cluster.Instance, String>(){

            public String apply(Cluster.Instance instance) {
                try {
                    String host = internalHost ? instance.getPrivateHostName() : instance.getPublicHostName();
                    return String.format("%s:%d", host, 2181);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
    }
}

