/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.zookeeper.integration;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import junit.framework.Assert;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterControllerFactory;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.service.zookeeper.ZooKeeperCluster;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ZooKeeperServiceTest {
    private ClusterSpec clusterSpec;
    private Cluster cluster;
    private ClusterController controller;
    private String hosts;

    @Before
    public void setUp() throws Exception {
        CompositeConfiguration config = new CompositeConfiguration();
        if (System.getProperty("config") != null) {
            config.addConfiguration((Configuration)new PropertiesConfiguration(System.getProperty("config")));
        }
        config.addConfiguration((Configuration)new PropertiesConfiguration("whirr-zookeeper-test.properties"));
        this.clusterSpec = ClusterSpec.withTemporaryKeys((Configuration)config);
        this.controller = new ClusterControllerFactory().create(this.clusterSpec.getServiceName());
        this.cluster = this.controller.launchCluster(this.clusterSpec);
        this.hosts = ZooKeeperCluster.getHosts((Cluster)this.cluster);
    }

    @Test(timeout=900000L)
    public void test() throws Exception {
        String path = "/data";
        String data = "Hello";
        class ConnectionWatcher
        implements Watcher {
            private ZooKeeper zk;
            private CountDownLatch latch = new CountDownLatch(1);

            ConnectionWatcher() {
            }

            public void connect(String hosts) throws IOException, InterruptedException {
                this.zk = new ZooKeeper(hosts, 5000, (Watcher)this);
                this.latch.await();
            }

            public ZooKeeper getZooKeeper() {
                return this.zk;
            }

            public void process(WatchedEvent event) {
                if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    this.latch.countDown();
                }
            }

            public void close() throws InterruptedException {
                if (this.zk != null) {
                    this.zk.close();
                }
            }
        }
        ConnectionWatcher watcher = new ConnectionWatcher();
        watcher.connect(this.hosts);
        watcher.getZooKeeper().create(path, data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        watcher.close();
        watcher = new ConnectionWatcher();
        watcher.connect(this.hosts);
        byte[] actualData = watcher.getZooKeeper().getData(path, false, null);
        Assert.assertEquals((String)data, (String)new String(actualData));
        watcher.close();
    }

    @After
    public void tearDown() throws IOException, InterruptedException {
        this.controller.destroyCluster(this.clusterSpec);
    }
}

