/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.yarn.osgi;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.whirr.service.ClusterActionHandler;
import org.apache.whirr.service.yarn.YarnNodeManagerHandler;
import org.apache.whirr.service.yarn.YarnResourceManagerHandler;
import org.jclouds.scriptbuilder.functionloader.osgi.BundleFunctionLoader;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private BundleFunctionLoader functionLoader;
    private final ClusterActionHandler nodeManagerClusterActionHandler = new YarnNodeManagerHandler();
    private ServiceRegistration nodeManagerRegistration;
    private final ClusterActionHandler resourceManagerClusterActionHandler = new YarnResourceManagerHandler();
    private ServiceRegistration resourceManagerRegistration;

    public void start(BundleContext context) throws Exception {
        this.functionLoader = new BundleFunctionLoader(context);
        this.functionLoader.start();
        Properties nodeManagerProps = new Properties();
        nodeManagerProps.put("name", "yarn-nodemanager");
        this.nodeManagerRegistration = context.registerService(ClusterActionHandler.class.getName(), (Object)this.nodeManagerClusterActionHandler, (Dictionary)nodeManagerProps);
        Properties resourceManagerProps = new Properties();
        resourceManagerProps.put("name", "yarn-resourcemanager");
        this.resourceManagerRegistration = context.registerService(ClusterActionHandler.class.getName(), (Object)this.resourceManagerClusterActionHandler, (Dictionary)resourceManagerProps);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.nodeManagerRegistration != null) {
            this.nodeManagerRegistration.unregister();
        }
        if (this.resourceManagerRegistration != null) {
            this.resourceManagerRegistration.unregister();
        }
        if (this.functionLoader != null) {
            this.functionLoader.stop();
        }
    }
}

