/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.yarn;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.FirewallManager;
import org.apache.whirr.service.hadoop.HadoopConfigurationConverter;
import org.apache.whirr.service.yarn.YarnConfigurationBuilder;
import org.apache.whirr.service.yarn.YarnHandler;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnResourceManagerHandler
extends YarnHandler {
    private static final Logger LOG = LoggerFactory.getLogger(YarnResourceManagerHandler.class);
    public static final String ROLE = "yarn-resourcemanager";
    public static final int RESOURCE_MANAGER_RPC_PORT = 8040;
    public static final int RESOURCE_MANAGER_WEB_UI_PORT = 8088;

    public String getRole() {
        return ROLE;
    }

    protected void beforeConfigure(ClusterActionEvent event) throws IOException, InterruptedException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Configuration conf = this.getConfiguration(clusterSpec);
        Cluster cluster = event.getCluster();
        Cluster.Instance resourceManager = cluster.getInstanceMatching(RolePredicates.role((String)ROLE));
        event.getFirewallManager().addRules(new FirewallManager.Rule[]{FirewallManager.Rule.create().destination(resourceManager).ports(new int[]{8040, 8088}), FirewallManager.Rule.create().source(resourceManager.getPublicIp()).destination(resourceManager).ports(new int[]{8040})});
        try {
            event.getStatementBuilder().addStatements(new Statement[]{YarnConfigurationBuilder.build("/tmp/yarn-site.xml", clusterSpec, cluster, ROLE)});
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
        YarnResourceManagerHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getConfigureFunction(conf), (String[])new String[0]));
        YarnResourceManagerHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getStartFunction(conf), (String[])new String[]{"resourcemanager"}));
    }

    protected void afterConfigure(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        Cluster.Instance resourceManager = cluster.getInstanceMatching(RolePredicates.role((String)ROLE));
        LOG.info("Resource manager web UI available at http://{}:{}", (Object)resourceManager.getPublicHostName(), (Object)8088);
        Properties mrConfig = this.createClientSideMapReduceProperties(clusterSpec);
        this.createClientSideMapReduceSiteFile(clusterSpec, mrConfig);
        Properties yarnConfig = this.createClientSideYarnProperties(clusterSpec, resourceManager);
        this.createClientSideYarnSiteFile(clusterSpec, yarnConfig);
        Properties combined = new Properties();
        combined.putAll((Map<?, ?>)cluster.getConfiguration());
        combined.putAll((Map<?, ?>)mrConfig);
        combined.putAll((Map<?, ?>)yarnConfig);
        event.setCluster(new Cluster(cluster.getInstances(), combined));
    }

    private Properties createClientSideMapReduceProperties(ClusterSpec clusterSpec) throws IOException {
        Properties config = new Properties();
        config.setProperty("mapreduce.framework.name", "yarn");
        config.setProperty("mapreduce.jobhistory.address", "");
        return config;
    }

    private Properties createClientSideYarnProperties(ClusterSpec clusterSpec, Cluster.Instance resourceManager) throws IOException {
        Properties config = new Properties();
        String prefix = "hadoop-yarn";
        Configuration sub = clusterSpec.getConfigurationForKeysWithPrefix(prefix);
        sub = sub.subset(prefix);
        Iterator it = sub.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = StringUtils.join((Object[])sub.getStringArray(key), (char)AbstractConfiguration.getDefaultListDelimiter());
            config.setProperty(key, value);
            System.out.println("createClientSideYarnProperties " + key + ":" + value);
        }
        config.setProperty("yarn.resourcemanager.address", String.format("%s:8040", resourceManager.getPublicHostName()));
        config.setProperty("yarn.resourcemanager.scheduler.address", String.format("%s:8030", resourceManager.getPublicHostName()));
        config.setProperty("yarn.resourcemanager.resource-tracker.address", String.format("%s:8025", resourceManager.getPublicHostName()));
        config.setProperty("yarn.app.mapreduce.am.staging-dir", "/user");
        return config;
    }

    private void createClientSideMapReduceSiteFile(ClusterSpec clusterSpec, Properties config) {
        File configDir = this.getConfigDir(clusterSpec);
        File hadoopSiteFile = new File(configDir, "mapred-site.xml");
        HadoopConfigurationConverter.createClientSideHadoopSiteFile((File)hadoopSiteFile, (Properties)config);
    }

    private void createClientSideYarnSiteFile(ClusterSpec clusterSpec, Properties config) {
        File configDir = this.getConfigDir(clusterSpec);
        File hadoopSiteFile = new File(configDir, "yarn-site.xml");
        HadoopConfigurationConverter.createClientSideHadoopSiteFile((File)hadoopSiteFile, (Properties)config);
    }

    private File getConfigDir(ClusterSpec clusterSpec) {
        File configDir = new File(new File(System.getProperty("user.home")), ".whirr");
        configDir = new File(configDir, clusterSpec.getClusterName());
        configDir.mkdirs();
        return configDir;
    }
}

