/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.yarn;

import java.io.IOException;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.FirewallManager;
import org.apache.whirr.service.yarn.YarnConfigurationBuilder;
import org.apache.whirr.service.yarn.YarnHandler;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class YarnNodeManagerHandler
extends YarnHandler {
    public static final String ROLE = "yarn-nodemanager";
    public static final int NODE_MANAGER_WEB_UI_PORT = 9999;

    public String getRole() {
        return ROLE;
    }

    protected void beforeConfigure(ClusterActionEvent event) throws IOException, InterruptedException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Configuration conf = this.getConfiguration(clusterSpec);
        Cluster cluster = event.getCluster();
        Set nodeManagers = cluster.getInstancesMatching(RolePredicates.role((String)ROLE));
        if (!nodeManagers.isEmpty()) {
            for (Cluster.Instance nodeManager : nodeManagers) {
                event.getFirewallManager().addRules(new FirewallManager.Rule[]{FirewallManager.Rule.create().destination(nodeManager).ports(new int[]{9999})});
            }
        }
        try {
            event.getStatementBuilder().addStatements(new Statement[]{YarnConfigurationBuilder.build("/tmp/yarn-site.xml", clusterSpec, cluster, ROLE)});
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
        YarnNodeManagerHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getConfigureFunction(conf), (String[])new String[0]));
        YarnNodeManagerHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getStartFunction(conf), (String[])new String[]{"nodemanager"}));
    }
}

