/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.yarn;

import java.io.IOException;
import org.apache.commons.configuration.Configuration;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.ClusterActionHandlerSupport;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public abstract class YarnHandler
extends ClusterActionHandlerSupport {
    protected Configuration getConfiguration(ClusterSpec clusterSpec) throws IOException {
        return this.getConfiguration(clusterSpec, "whirr-yarn-default.properties");
    }

    protected String getInstallFunction(Configuration config) {
        return this.getInstallFunction(config, "hadoop", "install_hadoop_mr2");
    }

    protected String getConfigureFunction(Configuration config) {
        return this.getConfigureFunction(config, "yarn", "configure_yarn");
    }

    protected String getStartFunction(Configuration config) {
        return this.getStartFunction(config, "yarn", "start_yarn");
    }

    protected void beforeBootstrap(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Configuration conf = this.getConfiguration(clusterSpec);
        YarnHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        YarnHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"configure_hostnames", (String[])new String[0]));
        YarnHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getInstallFunction(conf, "java", "install_openjdk"), (String[])new String[0]));
        YarnHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_tarball", (String[])new String[0]));
        String installFn = this.getInstallFunction(conf);
        String tarball = YarnHandler.prepareRemoteFileUrl((ClusterActionEvent)event, (String)conf.getString("whirr.hadoop.tarball.url"));
        YarnHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)installFn, (String[])new String[]{"-u", tarball}));
    }
}

