/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.yarn;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.hadoop.HadoopConfigurationConverter;
import org.jclouds.scriptbuilder.domain.Statement;

public class YarnConfigurationBuilder {
    private static final String WHIRR_YARN_DEFAULT_PROPERTIES = "whirr-yarn-default.properties";

    private static Configuration build(ClusterSpec clusterSpec, Cluster cluster, Configuration defaults, String prefix) throws ConfigurationException {
        CompositeConfiguration config = new CompositeConfiguration();
        Configuration sub = clusterSpec.getConfigurationForKeysWithPrefix(prefix);
        config.setDelimiterParsingDisabled(true);
        config.addConfiguration(sub.subset(prefix));
        config.addConfiguration(defaults.subset(prefix));
        return config;
    }

    public static Statement build(String path, ClusterSpec clusterSpec, Cluster cluster, String role) throws ConfigurationException, IOException {
        Configuration config = YarnConfigurationBuilder.buildConfiguration(clusterSpec, cluster, role, (Configuration)new PropertiesConfiguration(YarnConfigurationBuilder.class.getResource("/whirr-yarn-default.properties")));
        return HadoopConfigurationConverter.asCreateXmlConfigurationFileStatement((String)path, (Configuration)config);
    }

    @VisibleForTesting
    static Configuration buildConfiguration(ClusterSpec clusterSpec, Cluster cluster, String role, Configuration defaults) throws ConfigurationException, IOException {
        Configuration config = YarnConfigurationBuilder.build(clusterSpec, cluster, defaults, "hadoop-yarn");
        if (role.equals("yarn-resourcemanager")) {
            config.setProperty("yarn.resourcemanager.address", (Object)"0.0.0.0:8040");
            config.setProperty("yarn.resourcemanager.scheduler.address", (Object)"0.0.0.0:8030");
            config.setProperty("yarn.resourcemanager.resource-tracker.address", (Object)"0.0.0.0:8025");
        } else {
            Cluster.Instance resourceManager = cluster.getInstanceMatching(RolePredicates.role((String)"yarn-resourcemanager"));
            String resourceManagerPrivateAddress = resourceManager.getPrivateAddress().getHostName();
            config.setProperty("yarn.resourcemanager.address", (Object)String.format("%s:8040", resourceManagerPrivateAddress));
            config.setProperty("yarn.resourcemanager.scheduler.address", (Object)String.format("%s:8030", resourceManagerPrivateAddress));
            config.setProperty("yarn.resourcemanager.resource-tracker.address", (Object)String.format("%s:8025", resourceManagerPrivateAddress));
        }
        return config;
    }
}

