/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.puppet.statements;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class InstallModuleFromGit
implements Statement {
    private final String module;
    private final URI url;
    private final String vcsBranch;

    public InstallModuleFromGit(String module, URI url) {
        this(module, url, null);
    }

    public InstallModuleFromGit(String module, URI url, @Nullable String vcsBranch) {
        this.module = (String)Preconditions.checkNotNull((Object)module, (Object)"module");
        this.url = (URI)Preconditions.checkNotNull((Object)url, (Object)"url");
        Preconditions.checkArgument((boolean)url.getScheme().equals("git"), (String)"not a git url: %s", (Object[])new Object[]{url});
        this.vcsBranch = vcsBranch;
    }

    public Iterable<String> functionDependencies(OsFamily arg0) {
        return ImmutableSet.of();
    }

    public String render(OsFamily arg0) {
        return Statements.exec((String)("git clone " + (this.vcsBranch != null ? "-b " + this.vcsBranch + " " : "") + this.url + " " + "/etc/puppet/modules/" + this.module)).render(arg0);
    }
}

