/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.puppet.statements;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.whirr.service.puppet.Manifest;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSitePpAndApplyRoles
implements Statement {
    private Iterable<String> roles;
    private Configuration config;
    static final Logger LOG = LoggerFactory.getLogger(CreateSitePpAndApplyRoles.class);

    public CreateSitePpAndApplyRoles(Iterable<String> roles, Configuration config) {
        this.roles = (Iterable)Preconditions.checkNotNull(roles, (Object)"roles");
        this.config = (Configuration)Preconditions.checkNotNull((Object)config, (Object)"config");
    }

    public Iterable<String> functionDependencies(OsFamily arg0) {
        return ImmutableSet.of();
    }

    public String render(OsFamily arg0) {
        ImmutableList.Builder statements = ImmutableList.builder();
        statements.add((Object)Statements.rm((String)"/etc/puppet/manifests/site.pp"));
        ImmutableList.Builder sitePp = ImmutableList.builder();
        sitePp.add((Object)"node default {");
        for (String role : this.roles) {
            String manifestAttribPrefix = role.replaceAll(":+", ".");
            PropertiesConfiguration manifestProps = new PropertiesConfiguration();
            Iterator it = this.config.getKeys(manifestAttribPrefix);
            while (it.hasNext()) {
                String key = (String)it.next();
                manifestProps.setProperty(key, this.config.getProperty(key));
            }
            sitePp.add((Object)CreateSitePpAndApplyRoles.getManifestForClusterSpecAndRole(role, (Configuration)manifestProps).toString());
        }
        sitePp.add((Object)"}");
        statements.add((Object)Statements.appendFile((String)"/etc/puppet/manifests/site.pp", (Iterable)sitePp.build()));
        statements.add((Object)Statements.exec((String)"puppet apply /etc/puppet/manifests/site.pp"));
        return new StatementList((Iterable)statements.build()).render(arg0);
    }

    @VisibleForTesting
    static Manifest getManifestForClusterSpecAndRole(String subroleModuleManifest, Configuration manifestProps) {
        String manifestClassName;
        String moduleName;
        int firstColon = subroleModuleManifest.indexOf(58);
        if (firstColon == -1) {
            moduleName = subroleModuleManifest;
            manifestClassName = null;
        } else {
            moduleName = subroleModuleManifest.substring(0, firstColon);
            int firstDoubleColon = subroleModuleManifest.indexOf("::");
            if (firstDoubleColon != firstColon) {
                throw new IllegalArgumentException("Malformed subrole spec for role puppet: format should be puppet:module or puppet:module::manifest");
            }
            manifestClassName = subroleModuleManifest.substring(firstDoubleColon + 2);
        }
        Manifest manifest = new Manifest(moduleName, manifestClassName);
        Iterator longkeyI = manifestProps.getKeys();
        while (longkeyI.hasNext()) {
            String longkey = (String)longkeyI.next();
            String key = longkey.substring(subroleModuleManifest.replaceAll(":+", ".").length() + 1);
            if (key.indexOf(46) >= 0) continue;
            Object value = manifestProps.getProperty(longkey);
            String vs = "";
            if (value == null) {
                LOG.warn("Invalid value for key " + longkey + ": null");
            } else if (value instanceof Collection) {
                Iterator vi = ((Collection)value).iterator();
                if (!vi.hasNext()) {
                    LOG.warn("Invalid value for key " + longkey + ": empty list");
                } else {
                    vs = vs + vi.next();
                    while (vi.hasNext()) {
                        vs = vs + ", " + vi.next();
                    }
                }
            } else {
                vs = value.toString();
            }
            manifest.attribs.put(key, vs);
        }
        LOG.debug("Bootstrapping " + subroleModuleManifest + ", produced manifest:\n" + manifest);
        return manifest;
    }
}

