/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.puppet.predicates;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;

public class PuppetPredicates {
    public static Predicate<String> isFirstPuppetRoleIn(final Iterable<String> roles) {
        return new Predicate<String>(){

            public boolean apply(String arg0) {
                return ((String)Iterables.get((Iterable)Iterables.filter((Iterable)roles, (Predicate)Predicates.containsPattern((String)("^puppet:" + arg0))), (int)0)).equals("puppet:" + arg0);
            }

            public String toString() {
                return "isFirstPuppetRoleIn(" + roles + ")";
            }
        };
    }

    public static Predicate<CharSequence> isPuppetRole() {
        return Predicates.containsPattern((String)"^puppet:");
    }

    public static Predicate<String> isLastPuppetRoleIn(final Iterable<String> roles) {
        return new Predicate<String>(){

            public boolean apply(String arg0) {
                return ((String)Iterables.getLast((Iterable)Iterables.filter((Iterable)roles, (Predicate)Predicates.containsPattern((String)("^puppet:" + arg0))))).equals("puppet:" + arg0);
            }

            public String toString() {
                return "isLastPuppetRoleIn(" + roles + ")";
            }
        };
    }

    public static Predicate<String> isModuleSubKey(final String module) {
        return new Predicate<String>(){

            public boolean apply(String arg0) {
                return arg0.startsWith("puppet." + module + "." + "module");
            }

            public String toString() {
                return "isModuleSubKey(" + module + ")";
            }
        };
    }
}

