/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.puppet.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.ClusterActionHandlerSupport;
import org.apache.whirr.service.puppet.PuppetConstants;
import org.apache.whirr.service.puppet.statements.InstallModuleFromGit;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementToInstallModule
implements Function<Map<String, String>, Statement> {
    static final Logger LOG = LoggerFactory.getLogger(StatementToInstallModule.class);
    private final PrepareRemoteFileUrl prepareRemoteFileUrl;

    public StatementToInstallModule(ClusterActionEvent event) {
        this(new PrepareRemoteFileUrlUsingBlobCache(event));
    }

    public StatementToInstallModule(PrepareRemoteFileUrl prepareRemoteFileUrl) {
        this.prepareRemoteFileUrl = (PrepareRemoteFileUrl)Preconditions.checkNotNull((Object)prepareRemoteFileUrl, (Object)"prepareRemoteFileUrl");
    }

    public Statement apply(Map<String, String> props) {
        try {
            return this.installModuleFromRemoteFileOrGit((String)Iterables.find(props.keySet(), (Predicate)Predicates.contains((Pattern)PuppetConstants.MODULE_KEY_PATTERN)), props);
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException(String.format("couldn't find pattern: %s in properties %s", PuppetConstants.MODULE_KEY_PATTERN, props));
        }
    }

    private Statement installModuleFromRemoteFileOrGit(String roleKey, Map<String, String> props) {
        String moduleName = roleKey.substring("puppet".length() + 1).replaceAll("\\..*", "");
        URI srcUri = URI.create(props.get(roleKey));
        if ("git".equals(srcUri.getScheme())) {
            return new InstallModuleFromGit(moduleName, srcUri, props.get(roleKey + ".branch"));
        }
        try {
            String remotelyAccessibleUrl = this.prepareRemoteFileUrl.apply(srcUri.toASCIIString());
            return Statements.call((String)"install_tarball", (String[])new String[]{remotelyAccessibleUrl, "/etc/puppet/modules/" + moduleName});
        }
        catch (IOException e) {
            throw new IllegalArgumentException("problem getting src: " + srcUri, e);
        }
    }

    public static class PrepareRemoteFileUrlUsingBlobCache
    implements PrepareRemoteFileUrl {
        private final ClusterActionEvent event;

        public PrepareRemoteFileUrlUsingBlobCache(ClusterActionEvent event) {
            this.event = (ClusterActionEvent)Preconditions.checkNotNull((Object)event, (Object)"event");
        }

        @Override
        public String apply(String rawUrl) throws IOException {
            return ClusterActionHandlerSupport.prepareRemoteFileUrl((ClusterActionEvent)this.event, (String)rawUrl);
        }
    }

    @VisibleForTesting
    public static interface PrepareRemoteFileUrl {
        public String apply(String var1) throws IOException;
    }
}

