/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.puppet.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.whirr.service.puppet.PuppetConstants;
import org.apache.whirr.service.puppet.functions.KeyToModuleNameOrNull;
import org.apache.whirr.service.puppet.functions.StatementToInstallModule;
import org.apache.whirr.service.puppet.predicates.PuppetPredicates;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;

public class InstallAllModulesStatementFromProperties
implements Function<Map<String, String>, Statement> {
    private final StatementToInstallModule statementMaker;

    public InstallAllModulesStatementFromProperties(StatementToInstallModule statementMaker) {
        this.statementMaker = (StatementToInstallModule)Preconditions.checkNotNull((Object)statementMaker, (Object)"statementMaker");
    }

    public Statement apply(Map<String, String> moduleProps) {
        ImmutableSet allModules = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter(moduleProps.keySet(), (Predicate)Predicates.contains((Pattern)PuppetConstants.MODULE_KEY_PATTERN)), (Function)KeyToModuleNameOrNull.INSTANCE));
        ImmutableSet.Builder statements = ImmutableSet.builder();
        for (String module : allModules) {
            statements.add((Object)this.statementMaker.apply(Maps.filterKeys(moduleProps, PuppetPredicates.isModuleSubKey(module))));
        }
        StatementList installModules = new StatementList((Iterable)statements.build());
        return installModules;
    }
}

