/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.puppet;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.puppet.PuppetInstallClusterActionHandler;
import org.apache.whirr.service.puppet.functions.InstallAllModulesStatementFromProperties;
import org.apache.whirr.service.puppet.functions.ModulePropertiesFromConfiguration;
import org.apache.whirr.service.puppet.functions.RolesManagedByPuppet;
import org.apache.whirr.service.puppet.functions.StatementToInstallModule;
import org.apache.whirr.service.puppet.predicates.PuppetPredicates;
import org.apache.whirr.service.puppet.statements.CreateSitePpAndApplyRoles;
import org.jclouds.scriptbuilder.domain.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PuppetClusterActionHandler
extends PuppetInstallClusterActionHandler {
    static final Logger LOG = LoggerFactory.getLogger(PuppetClusterActionHandler.class);
    private final String role;
    private final Function<ClusterActionEvent, StatementToInstallModule> getStatementToInstallModuleForAction;

    public PuppetClusterActionHandler(String role) {
        this(role, new Function<ClusterActionEvent, StatementToInstallModule>(){

            public StatementToInstallModule apply(ClusterActionEvent arg0) {
                return new StatementToInstallModule(arg0);
            }
        });
    }

    public PuppetClusterActionHandler(String role, Function<ClusterActionEvent, StatementToInstallModule> getStatementToInstallModuleForAction) {
        this.role = (String)Preconditions.checkNotNull((Object)role, (Object)"role");
        this.getStatementToInstallModuleForAction = (Function)Preconditions.checkNotNull(getStatementToInstallModuleForAction, (Object)"getStatementToInstallModuleForAction");
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @Override
    protected void beforeBootstrap(ClusterActionEvent event) throws IOException, InterruptedException {
        if (PuppetPredicates.isFirstPuppetRoleIn(event.getInstanceTemplate().getRoles()).apply((Object)this.getRole())) {
            super.beforeBootstrap(event);
            this.installAllKnownModules(event);
        }
    }

    private void installAllKnownModules(ClusterActionEvent event) throws IOException {
        Map<String, String> moduleProps = ModulePropertiesFromConfiguration.INSTANCE.apply(event.getClusterSpec().getConfigurationForKeysWithPrefix("puppet"));
        StatementToInstallModule statementMaker = (StatementToInstallModule)this.getStatementToInstallModuleForAction.apply((Object)event);
        Statement installModules = new InstallAllModulesStatementFromProperties(statementMaker).apply(moduleProps);
        event.getStatementBuilder().addStatement(installModules);
        LOG.debug("Puppet finished installing modules for " + event.getInstanceTemplate());
    }

    protected void beforeConfigure(ClusterActionEvent event) throws IOException, InterruptedException {
        super.beforeConfigure(event);
        if (PuppetPredicates.isLastPuppetRoleIn(event.getInstanceTemplate().getRoles()).apply((Object)this.getRole())) {
            Configuration config = event.getClusterSpec().getConfiguration();
            Iterable<String> roles = RolesManagedByPuppet.INSTANCE.apply(event.getInstanceTemplate().getRoles());
            PuppetClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)new CreateSitePpAndApplyRoles(roles, config));
        }
    }
}

