/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.puppet;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Manifest {
    public final String module;
    public final String className;
    public final Map<String, String> attribs = new LinkedHashMap<String, String>();
    @VisibleForTesting
    String fileName = null;

    public Manifest(String module) {
        this(module, null);
    }

    public Manifest(String module, String className) {
        this.module = module;
        this.className = className;
        this.fileName = module + (className != null ? "::" + className : "") + "-" + System.currentTimeMillis();
        this.fileName = this.fileName.replace(":+", "-");
    }

    public String toString() {
        StringBuilder resource = new StringBuilder();
        for (String s : this.toStringList()) {
            if (resource.length() > 0) {
                resource.append("\n");
            }
            resource.append(s);
        }
        return resource.toString();
    }

    List<String> toStringList() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("class { '" + this.module + (this.className != null ? "::" + this.className : "") + "':");
        for (Map.Entry<String, String> entry : this.attribs.entrySet()) {
            result.add("  " + entry.getKey() + " => " + entry.getValue() + ",");
        }
        result.add("}");
        return result;
    }
}

