/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.puppet.integration;

import com.google.common.base.Predicate;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterSpec;
import org.jclouds.predicates.InetSocketAddressConnect;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.util.Strings2;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class PuppetServiceTest {
    private ClusterSpec clusterSpec;
    private ClusterController controller;
    private Cluster cluster;
    private RetryablePredicate<HostAndPort> socketTester;

    @Before
    public void setUp() throws Exception {
        CompositeConfiguration config = new CompositeConfiguration();
        if (System.getProperty("config") != null) {
            config.addConfiguration((Configuration)new PropertiesConfiguration(System.getProperty("config")));
        }
        config.addConfiguration((Configuration)new PropertiesConfiguration("whirr-puppet-test.properties"));
        this.clusterSpec = ClusterSpec.withTemporaryKeys((Configuration)config);
        this.controller = new ClusterController();
        this.cluster = this.controller.launchCluster(this.clusterSpec);
        this.socketTester = new RetryablePredicate((Predicate)new InetSocketAddressConnect(), 60L, 1L, TimeUnit.SECONDS);
    }

    @Test(timeout=900000L)
    public void testHttpAvailable() throws Exception {
        for (Cluster.Instance instance : this.cluster.getInstances()) {
            HostAndPort socket = HostAndPort.fromParts((String)instance.getPublicAddress().getHostAddress(), (int)80);
            assert (this.socketTester.apply((Object)socket)) : instance;
            URI httpUrl = URI.create("http://" + instance.getPublicAddress().getHostAddress());
            Strings2.toStringAndClose((InputStream)httpUrl.toURL().openStream());
        }
    }

    @After
    public void tearDown() throws IOException, InterruptedException {
        if (this.controller != null) {
            this.controller.destroyCluster(this.clusterSpec);
        }
    }
}

