/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.puppet.functions;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import junit.framework.Assert;
import org.apache.whirr.service.puppet.functions.StatementToInstallModule;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.junit.Test;

public class StatementToInstallModuleTest {
    StatementToInstallModule getStatement = new StatementToInstallModule(new StatementToInstallModule.PrepareRemoteFileUrl(){

        public String apply(String rawUrl) throws IOException {
            return rawUrl;
        }
    });

    @Test
    public void testWhenRemote() {
        Assert.assertEquals((String)"install_tarball remote://path/to/tgz /etc/puppet/modules/nginx || return 1\n", (String)this.getStatement.apply((Map)ImmutableMap.of((Object)"puppet.nginx.module", (Object)"remote://path/to/tgz")).render(OsFamily.UNIX));
    }

    @Test
    public void testWhenFile() {
        Assert.assertEquals((String)"install_tarball file://path/to/tgz /etc/puppet/modules/nginx || return 1\n", (String)this.getStatement.apply((Map)ImmutableMap.of((Object)"puppet.nginx.module", (Object)"file://path/to/tgz")).render(OsFamily.UNIX));
    }

    @Test
    public void testWhenGit() {
        Assert.assertEquals((String)"git clone git://github.com/puppetlabs/puppetlabs-nginx.git /etc/puppet/modules/nginx\n", (String)this.getStatement.apply((Map)ImmutableMap.of((Object)"puppet.nginx.module", (Object)"git://github.com/puppetlabs/puppetlabs-nginx.git")).render(OsFamily.UNIX));
    }

    @Test
    public void testWhenGitAndBranch() {
        Assert.assertEquals((String)"git clone -b notmaster git://github.com/puppetlabs/puppetlabs-nginx.git /etc/puppet/modules/nginx\n", (String)this.getStatement.apply((Map)ImmutableMap.of((Object)"puppet.nginx.module.branch", (Object)"notmaster", (Object)"puppet.nginx.module", (Object)"git://github.com/puppetlabs/puppetlabs-nginx.git")).render(OsFamily.UNIX));
    }
}

