/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.puppet;

import junit.framework.Assert;
import org.apache.whirr.service.puppet.Manifest;
import org.junit.Test;

public class ManifestTest {
    private static final String NGINX_PUPPET = "class { 'nginx':\n}";
    private static final String POSTGRES_PUPPET = "class { 'postgresql::server':\n}";
    private static final String NTP_PUPPET = "class { 'ntp':\n  servers => \"10.0.0.1\",\n}";

    @Test
    public void testPuppetConversion() {
        Manifest nginx = new Manifest("nginx", null);
        Assert.assertEquals((String)"Puppet representation is incorrect.", (String)NGINX_PUPPET, (String)nginx.toString());
    }

    @Test
    public void testPuppetConversionWithSpecificClass() {
        Manifest postgresql = new Manifest("postgresql", "server");
        Assert.assertEquals((String)"PUPPET representation is incorrect.", (String)POSTGRES_PUPPET, (String)postgresql.toString());
    }

    @Test
    public void testPuppetConversionWithAttribs() {
        Manifest ntp = new Manifest("ntp");
        ntp.attribs.put("servers", "\"10.0.0.1\"");
        Assert.assertEquals((String)"Puppet representation is incorrect.", (String)NTP_PUPPET, (String)ntp.toString());
    }
}

