/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.pig.integration;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.state.ClusterStateStoreFactory;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PigServiceTest {
    private static final Logger LOG = LoggerFactory.getLogger(PigServiceTest.class);
    private static ClusterSpec clusterSpec;
    private static ClusterController controller;

    @BeforeClass
    public static void setUp() throws Exception {
        CompositeConfiguration config = new CompositeConfiguration();
        if (System.getProperty("config") != null) {
            config.addConfiguration((Configuration)new PropertiesConfiguration(System.getProperty("config")));
        }
        config.addConfiguration((Configuration)new PropertiesConfiguration("whirr-pig-test.properties"));
        clusterSpec = ClusterSpec.withTemporaryKeys((Configuration)config);
        controller = new ClusterController();
        controller.launchCluster(clusterSpec);
    }

    @AfterClass
    public static void tearDown() throws IOException, InterruptedException {
        if (controller != null) {
            controller.destroyCluster(clusterSpec);
        }
    }

    @Test(timeout=900000L)
    public void testPigBin() throws Exception {
        Statement binPig = Statements.exec((String)". /etc/profile && pig -e fs -ls /");
        Cluster.Instance pigInstance = this.findPigInstance();
        Predicate pigClientRole = Predicates.and((Predicate)Predicates.alwaysTrue(), (Predicate)NodePredicates.withIds((String[])new String[]{pigInstance.getId()}));
        Map responses = controller.runScriptOnNodesMatching(clusterSpec, pigClientRole, binPig);
        LOG.info("Responses for Statement: " + binPig);
        for (Map.Entry entry : responses.entrySet()) {
            LOG.info("Node[" + ((NodeMetadata)entry.getKey()).getId() + "]: " + entry.getValue());
        }
        PigServiceTest.assertResponsesContain(responses, binPig, "/hadoop");
    }

    public static void assertResponsesContain(Map<? extends NodeMetadata, ExecResponse> responses, Statement statement, String text) {
        for (Map.Entry<? extends NodeMetadata, ExecResponse> entry : responses.entrySet()) {
            if (entry.getValue().getOutput().contains(text)) continue;
            Assert.failNotEquals((String)("Node: " + entry.getKey().getId() + " failed to execute the command: " + statement + " as could not find expected text"), (Object)text, (Object)entry.getValue());
        }
    }

    private Cluster.Instance findPigInstance() throws IOException {
        Cluster cluster = new ClusterStateStoreFactory().create(clusterSpec).load();
        return cluster.getInstanceMatching(RolePredicates.anyRoleIn((Set)Sets.newHashSet((Object[])new String[]{"pig-client"})));
    }
}

