/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.mapr;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.FirewallManager;
import org.apache.whirr.service.mapr.MapRCluster;
import org.apache.whirr.service.mapr.MapRClusterActionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRZookeeperClusterActionHandler
extends MapRClusterActionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MapRZookeeperClusterActionHandler.class);
    public static final String ROLE = "mapr-zookeeper";

    public String getRole() {
        return ROLE;
    }

    @Override
    protected void doBeforeConfigure(ClusterActionEvent event) throws IOException {
        Cluster cluster = event.getCluster();
        Set cldbInstances = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-cldb"));
        if (cldbInstances == null) {
            cldbInstances = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-mr-master"));
        } else {
            cldbInstances.addAll(cluster.getInstancesMatching(RolePredicates.role((String)"mapr-mr-master")));
        }
        Cluster.Instance cldbnode = (Cluster.Instance)Iterables.getFirst((Iterable)cldbInstances, null);
        event.getFirewallManager().addRules(new FirewallManager.Rule[]{FirewallManager.Rule.create().destination(cldbInstances).port(5181)});
    }

    protected void afterConfigure(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        LOG.info("Completed configuration of {} role {}", (Object)clusterSpec.getClusterName(), (Object)this.getRole());
        InetAddress cldbPublicAddress = MapRCluster.getCLDBPublicAddress(cluster);
        InetAddress jobtrackerPublicAddress = MapRCluster.getJobTrackerPublicAddress(cluster);
        Properties config = MapRZookeeperClusterActionHandler.createClientSideProperties(clusterSpec, cldbPublicAddress, jobtrackerPublicAddress);
        MapRZookeeperClusterActionHandler.createClientSideHadoopSiteFile(clusterSpec, config);
        Properties combined = new Properties();
        combined.putAll((Map<?, ?>)cluster.getConfiguration());
        combined.putAll((Map<?, ?>)config);
        event.setCluster(new Cluster(cluster.getInstances(), combined));
    }
}

