/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.mapr;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.nio.charset.Charset;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.service.mapr.MapRCluster;
import org.apache.whirr.util.KeyPair;

public class MapRProxy {
    private ClusterSpec clusterSpec;
    private Cluster cluster;
    private Process process;

    public MapRProxy(ClusterSpec clusterSpec, Cluster cluster) {
        this.clusterSpec = clusterSpec;
        this.cluster = cluster;
    }

    public String[] getProxyCommand() throws IOException {
        Preconditions.checkState((this.clusterSpec.getPrivateKeyFile() != null || this.clusterSpec.getPrivateKey() != null ? 1 : 0) != 0, (Object)"privateKey is needed");
        File identity = this.clusterSpec.getPrivateKeyFile();
        if (identity == null) {
            identity = File.createTempFile("mapr", "key");
            identity.deleteOnExit();
            Files.write((CharSequence)this.clusterSpec.getPrivateKey(), (File)identity, (Charset)Charsets.UTF_8);
        }
        KeyPair.setPermissionsTo600((File)identity);
        String user = this.clusterSpec.getClusterUser();
        InetAddress cldbnode = MapRCluster.getCLDBPublicAddress(this.cluster);
        String server = cldbnode.getHostAddress();
        return new String[]{"ssh", "-i", identity.getAbsolutePath(), "-o", "ConnectTimeout=10", "-o", "ServerAliveInterval=60", "-o", "StrictHostKeyChecking=no", "-o", "UserKnownHostsFile=/dev/null", "-o", "StrictHostKeyChecking=no", "-N", "-D 6666", String.format("%s@%s", user, server)};
    }

    public void start() throws IOException {
        String[] command = this.getProxyCommand();
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        this.process = processBuilder.start();
        final BufferedReader errReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        Thread errThread = new Thread(){

            @Override
            public void run() {
                try {
                    String line = errReader.readLine();
                    while (line != null && !this.isInterrupted()) {
                        System.err.println(line);
                        line = errReader.readLine();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        errThread.start();
    }

    public void stop() {
        this.process.destroy();
    }
}

