/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.mapr;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import java.util.Properties;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.FirewallManager;
import org.apache.whirr.service.mapr.MapRCluster;
import org.apache.whirr.service.mapr.MapRClusterActionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRMRMasterClusterActionHandler
extends MapRClusterActionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MapRMRMasterClusterActionHandler.class);
    public static final String ROLE = "mapr-mr-master";

    public String getRole() {
        return ROLE;
    }

    @Override
    protected void doBeforeConfigure(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        LOG.info("Begin configuration of {} role {}", (Object)clusterSpec.getClusterName(), (Object)this.getRole());
        if (cluster.getInstancesMatching(RolePredicates.role((String)ROLE)) != null) {
            event.getFirewallManager().addRules(new FirewallManager.Rule[]{FirewallManager.Rule.create().destination(RolePredicates.role((String)ROLE)).ports(new int[]{7222, 8443, 2049, 111})});
        }
    }

    protected void afterConfigure(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        LOG.info("Completed configuration of {} role {}", (Object)clusterSpec.getClusterName(), (Object)this.getRole());
        InetAddress cldbPublicAddress = MapRCluster.getCLDBPublicAddress(cluster);
        InetAddress jobtrackerPublicAddress = MapRCluster.getJobTrackerPublicAddress(cluster);
        Properties config = MapRMRMasterClusterActionHandler.createClientSideProperties(clusterSpec, cldbPublicAddress, jobtrackerPublicAddress);
        MapRMRMasterClusterActionHandler.createClientSideHadoopSiteFile(clusterSpec, config);
        MapRMRMasterClusterActionHandler.createProxyScript(clusterSpec, cluster);
        Properties combined = new Properties();
        combined.putAll((Map<?, ?>)cluster.getConfiguration());
        combined.putAll((Map<?, ?>)config);
        event.setCluster(new Cluster(cluster.getInstances(), combined));
    }
}

