/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.mapr;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Set;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.FirewallManager;
import org.apache.whirr.service.mapr.MapRCluster;
import org.apache.whirr.service.mapr.MapRClusterActionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRJobTrackerClusterActionHandler
extends MapRClusterActionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(MapRJobTrackerClusterActionHandler.class);
    public static final String ROLE = "mapr-jobtracker";

    public String getRole() {
        return ROLE;
    }

    @Override
    protected void doBeforeConfigure(ClusterActionEvent event) throws IOException {
        Cluster cluster = event.getCluster();
        Set jtInstances = cluster.getInstancesMatching(RolePredicates.role((String)ROLE));
        if (jtInstances == null) {
            jtInstances = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-mr-master"));
        } else {
            jtInstances.addAll(cluster.getInstancesMatching(RolePredicates.role((String)"mapr-mr-master")));
        }
        Cluster.Instance jobtracker = (Cluster.Instance)Iterables.getFirst((Iterable)jtInstances, null);
        event.getFirewallManager().addRules(new FirewallManager.Rule[]{FirewallManager.Rule.create().destination(RolePredicates.role((String)ROLE)).ports(new int[]{9001}), FirewallManager.Rule.create().destination(RolePredicates.role((String)"mapr-mr-master")).ports(new int[]{9001})});
    }

    protected void afterConfigure(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        LOG.info("Completed configuration of {} role {}", (Object)clusterSpec.getClusterName(), (Object)this.getRole());
        InetAddress jobtrackerPublicAddress = MapRCluster.getJobTrackerPublicAddress(cluster);
    }
}

