/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.mapr;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.mapr.MapRConfigurationConverter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Processor;
import org.jclouds.scriptbuilder.domain.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRConfigurationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(MapRConfigurationBuilder.class);
    private static final String WHIRR_MAPR_DEFAULT_PROPERTIES = "whirr-mapr-default.properties";

    private static Configuration build(ClusterSpec clusterSpec, Cluster cluster, Configuration defaults, String prefix) throws ConfigurationException {
        CompositeConfiguration config = new CompositeConfiguration();
        config.setDelimiterParsingDisabled(true);
        Configuration sub = clusterSpec.getConfigurationForKeysWithPrefix(prefix);
        config.addConfiguration(sub.subset(prefix));
        config.addConfiguration(defaults.subset(prefix));
        return config;
    }

    public static Statement buildCommon(String path, ClusterSpec clusterSpec, Cluster cluster) throws ConfigurationException, IOException {
        Configuration config = MapRConfigurationBuilder.buildCommonConfiguration(clusterSpec, cluster, (Configuration)new PropertiesConfiguration(MapRConfigurationBuilder.class.getResource("/whirr-mapr-default.properties")));
        return MapRConfigurationConverter.asCreateXmlConfigurationFileStatement(path, config);
    }

    public static Statement buildMapReduce(String path, ClusterSpec clusterSpec, Cluster cluster, Set<String> dataDirectories) throws ConfigurationException, IOException {
        Configuration config = MapRConfigurationBuilder.buildMapReduceConfiguration(clusterSpec, cluster, (Configuration)new PropertiesConfiguration(MapRConfigurationBuilder.class.getResource("/whirr-mapr-default.properties")), dataDirectories);
        return MapRConfigurationConverter.asCreateXmlConfigurationFileStatement(path, config);
    }

    public static Statement buildMapREnv(String path, ClusterSpec clusterSpec, Cluster cluster) throws ConfigurationException, IOException {
        Configuration config = MapRConfigurationBuilder.buildMapREnvConfiguration(clusterSpec, cluster, (Configuration)new PropertiesConfiguration(MapRConfigurationBuilder.class.getResource("/whirr-mapr-default.properties")));
        return MapRConfigurationConverter.asCreateEnvironmentVariablesFileStatement(path, config);
    }

    @VisibleForTesting
    static Configuration buildCommonConfiguration(ClusterSpec clusterSpec, Cluster cluster, Configuration defaults) throws ConfigurationException, IOException {
        Configuration config = MapRConfigurationBuilder.build(clusterSpec, cluster, defaults, "mapr-core");
        Set mrMasterNodes = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-mr-master"));
        Set cldbNodes = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-cldb"));
        if (cldbNodes == null || cldbNodes.size() == 0) {
            cldbNodes = mrMasterNodes;
        } else if (mrMasterNodes != null && mrMasterNodes.size() > 0) {
            cldbNodes.addAll(mrMasterNodes);
        }
        Set zkNodes = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-zookeeper"));
        if (zkNodes == null || zkNodes.size() == 0) {
            zkNodes = mrMasterNodes;
        } else if (mrMasterNodes != null && mrMasterNodes.size() > 0) {
            zkNodes.addAll(mrMasterNodes);
        }
        return config;
    }

    @VisibleForTesting
    static Configuration buildMapReduceConfiguration(ClusterSpec clusterSpec, Cluster cluster, Configuration defaults, Set<String> dataDirectories) throws ConfigurationException, IOException {
        Set jobtracker;
        Hardware hardware;
        Configuration config = MapRConfigurationBuilder.build(clusterSpec, cluster, defaults, "mapr-mapreduce");
        MapRConfigurationBuilder.setIfAbsent(config, "mapred.local.dir", MapRConfigurationBuilder.appendToDataDirectories(dataDirectories, "/mapred/local"));
        Set taskTrackers = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-tasktracker"));
        if (!taskTrackers.isEmpty() && (hardware = ((Cluster.Instance)Iterables.getFirst((Iterable)taskTrackers, null)).getNodeMetadata().getHardware()) != null) {
            int coresPerNode = 0;
            for (Processor processor : hardware.getProcessors()) {
                coresPerNode = (int)((double)coresPerNode + processor.getCores());
            }
            int mapTasksPerNode = (int)Math.ceil((double)coresPerNode * 1.0);
            int reduceTasksPerNode = (int)Math.ceil((double)coresPerNode * 0.75);
            MapRConfigurationBuilder.setIfAbsent(config, "mapred.tasktracker.map.tasks.maximum", mapTasksPerNode + "");
            MapRConfigurationBuilder.setIfAbsent(config, "mapred.tasktracker.reduce.tasks.maximum", reduceTasksPerNode + "");
            int clusterReduceSlots = taskTrackers.size() * reduceTasksPerNode;
            MapRConfigurationBuilder.setIfAbsent(config, "mapred.reduce.tasks", clusterReduceSlots + "");
        }
        if (!(jobtracker = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-jobtracker"))).isEmpty()) {
            config.setProperty("mapred.job.tracker", (Object)String.format("%s:8021", ((Cluster.Instance)Iterables.getOnlyElement((Iterable)jobtracker)).getPublicHostName()));
        }
        return config;
    }

    @VisibleForTesting
    static Configuration buildMapREnvConfiguration(ClusterSpec clusterSpec, Cluster cluster, Configuration defaults) throws ConfigurationException {
        return MapRConfigurationBuilder.build(clusterSpec, cluster, defaults, "mapr-env");
    }

    private static void setIfAbsent(Configuration config, String property, String value) {
        if (!config.containsKey(property)) {
            config.setProperty(property, (Object)value);
        }
    }

    private static String appendToDataDirectories(Set<String> dataDirectories, final String suffix) {
        return Joiner.on((char)',').join((Iterable)Lists.transform((List)Lists.newArrayList(dataDirectories), (Function)new Function<String, String>(){

            public String apply(String input) {
                return input + suffix;
            }
        }));
    }
}

