/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.mapr;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.IOUtils;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.net.FastDnsResolver;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.ClusterActionHandlerSupport;
import org.apache.whirr.service.mapr.MapRCluster;
import org.apache.whirr.service.mapr.MapRConfigurationConverter;
import org.apache.whirr.service.mapr.MapRProxy;
import org.apache.whirr.service.mapr.VolumeManager;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapRClusterActionHandler
extends ClusterActionHandlerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MapRClusterActionHandler.class);

    protected Configuration getConfiguration(ClusterSpec clusterSpec) throws IOException {
        return this.getConfiguration(clusterSpec, "whirr-mapr-default.properties");
    }

    protected String getInstallFunction(Configuration config) {
        return this.getInstallFunction(config, "mapr", "install_mapr");
    }

    protected String getConfigureFunction(Configuration config) {
        return this.getConfigureFunction(config, "mapr", "configure_mapr");
    }

    protected void beforeBootstrap(ClusterActionEvent event) throws IOException {
        LOG.info("MapRClusterActionHandler::beforeBootstrap() ... enter");
        ClusterSpec clusterSpec = event.getClusterSpec();
        Configuration conf = this.getConfiguration(clusterSpec);
        MapRClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        MapRClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"configure_mapr_hostnames", (String[])new String[0]));
        MapRClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getInstallFunction(conf, "java", "install_openjdk"), (String[])new String[0]));
        MapRClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getInstallFunction(conf), (String[])new String[0]));
        LOG.info("MapRClusterActionHandler::beforeBootstrap() ... exit");
    }

    protected Map<String, String> getDeviceMappings(ClusterActionEvent event) {
        Set instances = event.getCluster().getInstancesMatching(RolePredicates.role((String)this.getRole()));
        Cluster.Instance prototype = (Cluster.Instance)Iterables.getFirst((Iterable)instances, null);
        if (prototype == null) {
            throw new IllegalStateException("No instances found in role " + this.getRole());
        }
        VolumeManager volumeManager = new VolumeManager();
        return volumeManager.getDeviceMappings(event.getClusterSpec(), prototype);
    }

    protected void beforeConfigure(ClusterActionEvent event) throws IOException, InterruptedException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        this.doBeforeConfigure(event);
        this.createMapRConfigScript(event, clusterSpec, cluster);
        MapRClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        Integer nodeNum = 1;
        if (cluster != null) {
            Integer numNodes = cluster.getInstances().size();
            event.getStatementBuilder().addExport("MapR_Nodes", numNodes.toString());
            for (Cluster.Instance thisInst : cluster.getInstances()) {
                String id = thisInst.toString();
                String thisRole = Joiner.on((String)",").join((Iterable)thisInst.getRoles());
                event.getStatementBuilder().addExport("MapR_Instance_" + nodeNum.toString() + "_Roles", thisRole);
                event.getStatementBuilder().addExportPerInstance(thisInst.getId(), "MapR_Instance_Num", nodeNum.toString());
                event.getStatementBuilder().addExportPerInstance(thisInst.getId(), "MapR_Instance_ID", id);
                Integer n = nodeNum;
                Integer n2 = nodeNum = Integer.valueOf(nodeNum + 1);
            }
        } else {
            event.getStatementBuilder().addExport("MapR_Nodes", "0");
        }
        MapRClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getConfigureFunction(this.getConfiguration(clusterSpec)), (String[])new String[]{Joiner.on((String)",").join((Iterable)event.getInstanceTemplate().getRoles()), "-c", clusterSpec.getProvider()}));
    }

    protected void doBeforeConfigure(ClusterActionEvent event) throws IOException {
    }

    private void createMapRConfigScript(ClusterActionEvent event, ClusterSpec clusterSpec, Cluster cluster) throws IOException {
        LOG.info("createMapRConfigScript ... enter");
        Configuration conf = this.getConfiguration(clusterSpec);
        Set mrMasterNodes = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-mr-master"));
        Set cldbNodes = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-cldb"));
        if (cldbNodes == null || cldbNodes.size() == 0) {
            cldbNodes = mrMasterNodes;
        } else {
            cldbNodes.addAll(mrMasterNodes);
        }
        Set zkNodes = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-zookeeper"));
        if (zkNodes == null || zkNodes.size() == 0) {
            zkNodes = mrMasterNodes;
        } else {
            zkNodes.addAll(mrMasterNodes);
        }
        String cldbServers = null;
        String zkServers = null;
        if (cldbNodes != null && cldbNodes.size() > 0) {
            cldbServers = Joiner.on((char)',').join(MapRClusterActionHandler.getPrivateIps(cldbNodes));
        } else {
            LOG.info("No CLDB nodes defined for cluser !!");
        }
        if (zkNodes != null && zkNodes.size() > 0) {
            zkServers = Joiner.on((char)',').join(MapRClusterActionHandler.getPrivateIps(zkNodes));
        } else {
            LOG.info("No Zookeeper nodes defined for cluser !!");
        }
        String unmountPaths = clusterSpec.getConfiguration().getString("whirr.mapr-unmount", null);
        String skipDevices = clusterSpec.getConfiguration().getString("whirr.mapr-skip-devices", null);
        String uOpt = unmountPaths == null ? "" : "-u " + unmountPaths;
        String sOpt = skipDevices == null ? "" : "-s " + skipDevices;
        String cldbOpt = cldbServers == null ? "" : "-n " + cldbServers;
        String zkOpt = zkServers == null ? "" : "-z " + zkServers;
        boolean skip = clusterSpec.getConfiguration().getBoolean("whirr.mapr-skip-partitioning", false);
        String skipPartitioning = skip ? "-d" : "";
        MapRClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getConfigureFunction(conf), (String[])new String[]{uOpt, sOpt, cldbOpt, zkOpt, skipPartitioning}));
        String infoStr = String.format("%s %s %s %s %s", this.getConfigureFunction(conf), uOpt, sOpt, cldbOpt, zkOpt);
        LOG.info("configure script generated: {}", (Object)infoStr);
        LOG.info("createMapRConfigScript ... exit");
    }

    private String getMetricsTemplate(ClusterActionEvent event, ClusterSpec clusterSpec, Cluster cluster) {
        Configuration conf = clusterSpec.getConfiguration();
        if (conf.containsKey("mapr-metrics.template")) {
            return conf.getString("mapr-metrics.template");
        }
        Set gmetadInstances = cluster.getInstancesMatching(RolePredicates.role((String)"ganglia-metad"));
        if (!gmetadInstances.isEmpty()) {
            return "mapr-metrics-ganglia.properties.vm";
        }
        return "mapr-metrics-null.properties.vm";
    }

    public static Properties createClientSideProperties(ClusterSpec clusterSpec, InetAddress cldb, InetAddress jobtracker) throws IOException {
        Properties config = new Properties();
        FastDnsResolver fdr = new FastDnsResolver();
        config.setProperty("hadoop.job.ugi", "root,root");
        config.setProperty("fs.default.name", String.format("maprfs://%s:%d/", fdr.apply(cldb.getHostAddress()), 7222));
        config.setProperty("mapred.job.tracker", String.format("%s:%d", fdr.apply(jobtracker.getHostAddress()), 9001));
        config.setProperty("hadoop.socks.server", "localhost:6666");
        config.setProperty("hadoop.rpc.socket.factory.class.default", "org.apache.hadoop.net.SocksSocketFactory");
        if (clusterSpec.getProvider().endsWith("ec2")) {
            config.setProperty("fs.s3.awsAccessKeyId", clusterSpec.getIdentity());
            config.setProperty("fs.s3.awsSecretAccessKey", clusterSpec.getCredential());
            config.setProperty("fs.s3n.awsAccessKeyId", clusterSpec.getIdentity());
            config.setProperty("fs.s3n.awsSecretAccessKey", clusterSpec.getCredential());
        }
        return config;
    }

    public static void createClientSideHadoopSiteFile(ClusterSpec clusterSpec, Properties config) {
        File configDir = MapRClusterActionHandler.getConfigDir(clusterSpec);
        File hadoopSiteFile = new File(configDir, "hadoop-site.xml");
        MapRConfigurationConverter.createClientSideHadoopSiteFile(hadoopSiteFile, config);
    }

    public static File getConfigDir(ClusterSpec clusterSpec) {
        File configDir = new File(new File(System.getProperty("user.home")), ".whirr");
        configDir = new File(configDir, clusterSpec.getClusterName());
        configDir.mkdirs();
        return configDir;
    }

    public static void createProxyScript(ClusterSpec clusterSpec, Cluster cluster) {
        File configDir = MapRClusterActionHandler.getConfigDir(clusterSpec);
        File hadoopProxyFile = new File(configDir, "hadoop-proxy.sh");
        try {
            MapRProxy proxy = new MapRProxy(clusterSpec, cluster);
            InetAddress cldbnode = MapRCluster.getCLDBPublicAddress(cluster);
            String script = String.format("echo 'Running proxy to MapR cluster at %s. Use Ctrl-c to quit.'\n", cldbnode.getHostName()) + Joiner.on((String)" ").join((Object[])proxy.getProxyCommand());
            Files.write((CharSequence)script, (File)hadoopProxyFile, (Charset)Charsets.UTF_8);
            hadoopProxyFile.setExecutable(true);
            LOG.info("Wrote MapR proxy script {}", (Object)hadoopProxyFile);
        }
        catch (IOException e) {
            LOG.error("Problem writing MapR proxy script {}", (Object)hadoopProxyFile, (Object)e);
        }
    }

    public static List<String> getPrivateIps(Set<Cluster.Instance> instances) throws IOException {
        return Lists.transform((List)Lists.newArrayList(instances), (Function)new Function<Cluster.Instance, String>(){

            public String apply(Cluster.Instance instance) {
                try {
                    return instance.getPrivateAddress().getHostAddress();
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    public static List<String> getPublicIps(Set<Cluster.Instance> instances) throws IOException {
        return Lists.transform((List)Lists.newArrayList(instances), (Function)new Function<Cluster.Instance, String>(){

            public String apply(Cluster.Instance instance) {
                try {
                    return instance.getPrivateAddress().getHostAddress();
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }

    public static String getOriginatingClassC() throws IOException {
        try {
            URL url = new URL("http://checkip.amazonaws.com/");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            return IOUtils.toString((InputStream)connection.getInputStream()).trim() + "/24";
        }
        catch (IOException e) {
            return "62.217.232.123/24";
        }
    }
}

