/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.mapr;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Set;
import org.apache.whirr.Cluster;
import org.apache.whirr.RolePredicates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRCluster {
    private static final Logger LOG = LoggerFactory.getLogger(MapRCluster.class);
    public static final int CLDB_PORT = 7222;
    public static final int CLDB_WEB_UI_PORT = 7221;
    public static final int CLDB_JMX_PORT = 7220;
    public static final int JOBTRACKER_PORT = 9001;
    public static final int JOBTRACKER_WEB_UI_PORT = 50030;
    public static final int NFS_PORT = 2049;
    public static final int RPCBIND_PORT = 111;
    public static final int WEB_PORT = 8443;
    public static final int FILESERVER_PORT = 5660;
    public static final int TASKTRACKER_WEB_UI_PORT = 50060;
    public static final int HBASE_MASTER_WEB_PORT = 60010;
    public static final int HBASE_REGIONSERVER_WEB_PORT = 60030;
    public static final int ZOOKEEPER_PORT = 5181;
    public static final int ZOOKEEPER_FTL_PORT = 2888;
    public static final int ZOOKEEPER_ELECTION_PORT = 3888;

    public static InetAddress getCLDBPublicAddress(Cluster cluster) throws IOException {
        InetAddress cldbPublicAddress = null;
        long cldbIP = Long.MAX_VALUE;
        Set cldbInstances = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-cldb"));
        if (cldbInstances == null || cldbInstances.size() == 0) {
            cldbInstances = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-mr-master"));
        } else {
            cldbInstances.addAll(cluster.getInstancesMatching(RolePredicates.role((String)"mapr-mr-master")));
        }
        for (Cluster.Instance inst : cldbInstances) {
            InetAddress pAddr = inst.getPrivateAddress();
            long ip = MapRCluster.ipToLong(pAddr.getAddress());
            if (ip >= cldbIP) continue;
            cldbIP = ip;
            cldbPublicAddress = inst.getPublicAddress();
        }
        return cldbPublicAddress;
    }

    public static InetAddress getCLDBPrivateAddress(Cluster cluster) throws IOException {
        InetAddress cldbPrivateAddress = null;
        long cldbIP = Long.MAX_VALUE;
        Set cldbInstances = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-cldb"));
        if (cldbInstances == null || cldbInstances.size() == 0) {
            cldbInstances = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-mr-master"));
        } else {
            cldbInstances.addAll(cluster.getInstancesMatching(RolePredicates.role((String)"mapr-mr-master")));
        }
        for (Cluster.Instance inst : cldbInstances) {
            InetAddress pAddr = inst.getPrivateAddress();
            long ip = MapRCluster.ipToLong(pAddr.getAddress());
            if (ip >= cldbIP) continue;
            cldbIP = ip;
            cldbPrivateAddress = inst.getPrivateAddress();
        }
        return cldbPrivateAddress;
    }

    public static InetAddress getJobTrackerPublicAddress(Cluster cluster) throws IOException {
        InetAddress jtPublicAddress = null;
        long jtIP = Long.MAX_VALUE;
        Set jtInstances = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-jobtracker"));
        if (jtInstances == null || jtInstances.size() == 0) {
            jtInstances = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-mr-master"));
        } else {
            jtInstances.addAll(cluster.getInstancesMatching(RolePredicates.role((String)"mapr-mr-master")));
        }
        for (Cluster.Instance inst : jtInstances) {
            InetAddress pAddr = inst.getPrivateAddress();
            long ip = MapRCluster.ipToLong(pAddr.getAddress());
            if (ip >= jtIP) continue;
            jtIP = ip;
            jtPublicAddress = inst.getPublicAddress();
        }
        return jtPublicAddress;
    }

    public static InetAddress getJobTrackerPrivateAddress(Cluster cluster) throws IOException {
        InetAddress jtPrivateAddress = null;
        long jtIP = Long.MAX_VALUE;
        Set jtInstances = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-jobtracker"));
        if (jtInstances == null || jtInstances.size() == 0) {
            jtInstances = cluster.getInstancesMatching(RolePredicates.role((String)"mapr-mr-master"));
        } else {
            jtInstances.addAll(cluster.getInstancesMatching(RolePredicates.role((String)"mapr-mr-master")));
        }
        for (Cluster.Instance inst : jtInstances) {
            InetAddress pAddr = inst.getPrivateAddress();
            long ip = MapRCluster.ipToLong(pAddr.getAddress());
            if (ip >= jtIP) continue;
            jtIP = ip;
            jtPrivateAddress = inst.getPrivateAddress();
        }
        return jtPrivateAddress;
    }

    public static long ipToLong(byte[] address) {
        long ip = 0L;
        for (int i = 0; i < address.length; ++i) {
            ip <<= 8;
            ip |= (long)(address[i] & 0xFF);
        }
        return ip;
    }
}

