/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.mapr.integration.benchmark;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.TestDFSIO;
import org.apache.hadoop.mapred.JobConf;
import org.apache.whirr.service.mapr.integration.MapRServiceController;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRServiceTestDFSIOBenchmark {
    private static final Logger LOG = LoggerFactory.getLogger(MapRServiceTestDFSIOBenchmark.class);
    private static boolean shutdownClusterOnTearDown;
    private static MapRServiceController controller;

    @BeforeClass
    public static void setUp() throws Exception {
        MapRServiceController.getInstance("whirr-mapr-test.properties");
        shutdownClusterOnTearDown = controller.ensureClusterRunning();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (shutdownClusterOnTearDown) {
            controller.shutdown();
        }
    }

    @Test
    public void test() throws Exception {
        int runs = Integer.parseInt(System.getProperty("testDFSIORuns", "3"));
        for (int i = 0; i < runs; ++i) {
            LOG.info("Starting TestDFSIO run {} of {}", (Object)(i + 1), (Object)runs);
            TestDFSIO testDFSIO = new TestDFSIO();
            JobConf jobConf = controller.getJobConf();
            jobConf.set("test.build.data", "/user/root/benchmark/TestDFSIO");
            testDFSIO.setConf((Configuration)jobConf);
            testDFSIO.run("-write -nrFiles 10 -fileSize 1000".split(" "));
            testDFSIO.run("-read -nrFiles 10 -fileSize 1000".split(" "));
            testDFSIO.run(new String[]{"-clean"});
            LOG.info("Completed TestDFSIO run {} of {}", (Object)(i + 1), (Object)runs);
        }
    }
}

