/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.mapr.integration;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.lib.LongSumReducer;
import org.apache.hadoop.mapred.lib.TokenCountMapper;
import org.apache.whirr.service.mapr.integration.MapRServiceController;
import org.apache.whirr.service.mapr.integration.MapRServiceTest;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractMapRServiceTest {
    protected static MapRServiceController controller;

    @AfterClass
    public static void tearDown() throws Exception {
        controller.shutdown();
    }

    @Test(timeout=900000L)
    public void test() throws Exception {
        Configuration conf = controller.getConfiguration();
        JobConf job = new JobConf(conf, MapRServiceTest.class);
        FileSystem fs = FileSystem.get((Configuration)conf);
        FSDataOutputStream os = fs.create(new Path("input"));
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os);
        wr.write("b a\n");
        ((Writer)wr).close();
        job.setMapperClass(TokenCountMapper.class);
        job.setReducerClass(LongSumReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{new Path("input")});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)new Path("output"));
        JobClient.runJob((JobConf)job);
        FSDataInputStream in = fs.open(new Path("output/part-00000"));
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in));
        junit.framework.Assert.assertEquals((String)"a\t1", (String)reader.readLine());
        junit.framework.Assert.assertEquals((String)"b\t1", (String)reader.readLine());
        junit.framework.Assert.assertNull((Object)reader.readLine());
        reader.close();
    }

    @Test(timeout=900000L)
    public void testExistsTemporaryFolderAndHiveWarehouse() throws Exception {
        Configuration conf = controller.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Assert.assertThat((Object)fs.exists(new Path("/tmp")), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)fs.exists(new Path("/user/hive/warehouse")), (Matcher)Is.is((Object)true));
    }
}

