/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.mapr;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.net.DnsResolver;
import org.apache.whirr.net.FakeDnsResolver;
import org.apache.whirr.service.mapr.MapRConfigurationBuilder;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.internal.HardwareImpl;
import org.jclouds.domain.Credentials;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class MapRConfigurationBuilderTest {
    private Configuration defaults;
    private ClusterSpec clusterSpec;
    private Cluster cluster;

    static RegexMatcher matches(String regex) {
        return new RegexMatcher(regex);
    }

    @Before
    public void setUp() throws Exception {
        this.defaults = new PropertiesConfiguration();
        this.defaults.addProperty("mapr-core.p1", (Object)"core1");
        this.defaults.addProperty("mapr-core.p2", (Object)"core2");
        this.defaults.addProperty("mapr-mfs.p1", (Object)"mfs1");
        this.defaults.addProperty("mapr-mapreduce.p1", (Object)"mapred1");
        this.clusterSpec = ClusterSpec.withTemporaryKeys();
        this.cluster = this.newCluster(1);
    }

    private Cluster newCluster(int numberOfWorkers) {
        FakeDnsResolver fakeDnsResolver = new FakeDnsResolver();
        NodeMetadata node = (NodeMetadata)Mockito.mock(NodeMetadata.class);
        ImmutableList processors = ImmutableList.of((Object)new Processor(4.0, 1.0));
        HardwareImpl hardware = new HardwareImpl(null, null, "id", null, null, (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), (Iterable)processors, 1024, (Iterable)ImmutableList.of(), null, "xen");
        Mockito.when((Object)node.getHardware()).thenReturn((Object)hardware);
        ImmutableSet.Builder instances = ImmutableSet.builder();
        Cluster.Instance master = new Cluster.Instance(new Credentials("", ""), (Set)ImmutableSet.of((Object)"mapr-zookeeper", (Object)"mapr-cldb", (Object)"mapr-jobtracker", (Object)"mapr-fileserver", (Object)"mapr-tasktracker"), "10.0.0.1", "10.0.0.1", "1", node, (DnsResolver)fakeDnsResolver);
        instances.add((Object)master);
        for (int i = 0; i < numberOfWorkers; ++i) {
            int id = i + 2;
            instances.add((Object)new Cluster.Instance(new Credentials("", ""), (Set)ImmutableSet.of((Object)"mapr-fileserver", (Object)"mapr-tasktracker"), "10.0.0." + id, "10.0.0." + id, id + "", node, (DnsResolver)fakeDnsResolver));
        }
        return new Cluster((Set)instances.build());
    }

    @Test
    public void testCommon() throws Exception {
        Configuration conf = MapRConfigurationBuilder.buildCommonConfiguration((ClusterSpec)this.clusterSpec, (Cluster)this.cluster, (Configuration)this.defaults);
        Assert.assertThat((Object)Iterators.size((Iterator)conf.getKeys()), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)conf.getString("p1"), (Matcher)Matchers.is((Object)"core1"));
        Assert.assertThat((Object)conf.getString("p2"), (Matcher)Matchers.is((Object)"core2"));
    }

    @Test
    public void testOverrides() throws Exception {
        PropertiesConfiguration overrides = new PropertiesConfiguration();
        overrides.addProperty("mapr-core.p1", (Object)"overridden1");
        overrides.addProperty("mapr-core.p2", (Object)"overridden2");
        overrides.addProperty("mapr-core.fs.default.name", (Object)"not-overridden");
        this.clusterSpec = ClusterSpec.withNoDefaults((Configuration)overrides);
        Configuration conf = MapRConfigurationBuilder.buildCommonConfiguration((ClusterSpec)this.clusterSpec, (Cluster)this.cluster, (Configuration)this.defaults);
        Assert.assertThat((Object)Iterators.size((Iterator)conf.getKeys()), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)conf.getString("p1"), (Matcher)Matchers.is((Object)"overridden1"));
        Assert.assertThat((Object)conf.getString("p2"), (Matcher)Matchers.is((Object)"overridden2"));
    }

    @Test
    public void testMapReduce() throws Exception {
        Cluster cluster = this.newCluster(5);
        Configuration conf = MapRConfigurationBuilder.buildMapReduceConfiguration((ClusterSpec)this.clusterSpec, (Cluster)cluster, (Configuration)this.defaults, (Set)Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"/data0", "/data1"})));
        Assert.assertThat((Object)conf.getString("p1"), (Matcher)Matchers.is((Object)"mapred1"));
        Assert.assertThat((Object)conf.getString("mapred.job.tracker"), (Matcher)MapRConfigurationBuilderTest.matches(".+:8021"));
        Assert.assertThat((Object)conf.getString("mapred.tasktracker.map.tasks.maximum"), (Matcher)Matchers.is((Object)"4"));
        Assert.assertThat((Object)conf.getString("mapred.tasktracker.reduce.tasks.maximum"), (Matcher)Matchers.is((Object)"3"));
        Assert.assertThat((Object)conf.getString("mapred.reduce.tasks"), (Matcher)Matchers.is((Object)"18"));
        Assert.assertThat((Object)conf.getString("mapred.local.dir"), (Matcher)Matchers.is((Object)"/data0/mapred/local,/data1/mapred/local"));
    }

    @Test
    public void testOverridesNumberOfMappers() throws Exception {
        PropertiesConfiguration overrides = new PropertiesConfiguration();
        overrides.addProperty("mapr-mapreduce.mapred.tasktracker.map.tasks.maximum", (Object)"70");
        this.clusterSpec = ClusterSpec.withNoDefaults((Configuration)overrides);
        Configuration conf = MapRConfigurationBuilder.buildMapReduceConfiguration((ClusterSpec)this.clusterSpec, (Cluster)this.cluster, (Configuration)this.defaults, (Set)Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"/data0", "/data1"})));
        Assert.assertThat((Object)conf.getString("mapred.tasktracker.map.tasks.maximum"), (Matcher)Matchers.is((Object)"70"));
    }

    @Test
    public void testOverridesNumberOfReducers() throws Exception {
        PropertiesConfiguration overrides = new PropertiesConfiguration();
        overrides.addProperty("mapr-mapreduce.mapred.reduce.tasks", (Object)"7");
        this.clusterSpec = ClusterSpec.withNoDefaults((Configuration)overrides);
        Configuration conf = MapRConfigurationBuilder.buildMapReduceConfiguration((ClusterSpec)this.clusterSpec, (Cluster)this.cluster, (Configuration)this.defaults, (Set)Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"/data0", "/data1"})));
        Assert.assertThat((Object)conf.getString("mapred.reduce.tasks"), (Matcher)Matchers.is((Object)"7"));
    }

    static class RegexMatcher
    extends BaseMatcher<String> {
        private final String regex;

        public RegexMatcher(String regex) {
            this.regex = regex;
        }

        public boolean matches(Object o) {
            return ((String)o).matches(this.regex);
        }

        public void describeTo(Description description) {
            description.appendText("matches regex=");
        }
    }
}

