/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.mahout.integration;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.state.ClusterStateStoreFactory;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MahoutServiceTest {
    private static final Logger LOG = LoggerFactory.getLogger(MahoutServiceTest.class);
    private static ClusterSpec clusterSpec;
    private static ClusterController controller;

    @BeforeClass
    public static void setUp() throws Exception {
        CompositeConfiguration config = new CompositeConfiguration();
        if (System.getProperty("config") != null) {
            config.addConfiguration((Configuration)new PropertiesConfiguration(System.getProperty("config")));
        }
        config.addConfiguration((Configuration)new PropertiesConfiguration("whirr-mahout-test.properties"));
        clusterSpec = ClusterSpec.withTemporaryKeys((Configuration)config);
        controller = new ClusterController();
        controller.launchCluster(clusterSpec);
    }

    @AfterClass
    public static void tearDown() throws IOException, InterruptedException {
        if (controller != null) {
            controller.destroyCluster(clusterSpec);
        }
    }

    @Test(timeout=900000L)
    public void testBinMahout() throws Exception {
        Statement binMahout = Statements.exec((String)"source /etc/profile; $MAHOUT_HOME/bin/mahout");
        Cluster.Instance mahoutInstance = this.findMahoutInstance();
        Predicate mahoutClientRole = Predicates.and((Predicate)Predicates.alwaysTrue(), (Predicate)NodePredicates.withIds((String[])new String[]{mahoutInstance.getId()}));
        Map responses = controller.runScriptOnNodesMatching(clusterSpec, mahoutClientRole, binMahout);
        LOG.info("Responses for Statement: " + binMahout);
        for (Map.Entry entry : responses.entrySet()) {
            LOG.info("Node[" + ((NodeMetadata)entry.getKey()).getId() + "]: " + entry.getValue());
        }
        MahoutServiceTest.assertResponsesContain(responses, binMahout, "Running on hadoop");
    }

    public static void assertResponsesContain(Map<? extends NodeMetadata, ExecResponse> responses, Statement statement, String text) {
        for (Map.Entry<? extends NodeMetadata, ExecResponse> entry : responses.entrySet()) {
            if (entry.getValue().getOutput().contains(text)) continue;
            Assert.failNotEquals((String)("Node: " + entry.getKey().getId() + " failed to execute the command: " + statement + " as could not find expected text"), (Object)text, (Object)entry.getValue());
        }
    }

    private Cluster.Instance findMahoutInstance() throws IOException {
        Cluster cluster = new ClusterStateStoreFactory().create(clusterSpec).load();
        return cluster.getInstanceMatching(RolePredicates.anyRoleIn((Set)Sets.newHashSet((Object[])new String[]{"mahout-client"})));
    }
}

