/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hbase.osgi;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.whirr.service.ClusterActionHandler;
import org.apache.whirr.service.hbase.HBaseAvroServerClusterActionHandler;
import org.apache.whirr.service.hbase.HBaseMasterClusterActionHandler;
import org.apache.whirr.service.hbase.HBaseRegionServerClusterActionHandler;
import org.apache.whirr.service.hbase.HBaseRestServerClusterActionHandler;
import org.apache.whirr.service.hbase.HBaseThriftServerClusterActionHandler;
import org.jclouds.scriptbuilder.functionloader.osgi.BundleFunctionLoader;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private BundleFunctionLoader functionLoader;
    private final ClusterActionHandler masterClusterActionHandler = new HBaseMasterClusterActionHandler();
    private ServiceRegistration masterRegistration;
    private final ClusterActionHandler regionServerClusterActionHandler = new HBaseRegionServerClusterActionHandler();
    private ServiceRegistration regionServerRegistration;
    private final ClusterActionHandler restServerClusterActionHandler = new HBaseRestServerClusterActionHandler();
    private ServiceRegistration restServerRegistration;
    private final ClusterActionHandler avroServerClusterActionHandler = new HBaseAvroServerClusterActionHandler();
    private ServiceRegistration avroServerRegistration;
    private final ClusterActionHandler thriftServerClusterActionHandler = new HBaseThriftServerClusterActionHandler();
    private ServiceRegistration thriftServerRegistration;

    public void start(BundleContext context) throws Exception {
        this.functionLoader = new BundleFunctionLoader(context);
        this.functionLoader.start();
        Properties masterProps = new Properties();
        masterProps.put("name", "hbase-master");
        this.masterRegistration = context.registerService(ClusterActionHandler.class.getName(), (Object)this.masterClusterActionHandler, (Dictionary)masterProps);
        Properties regionServerProps = new Properties();
        regionServerProps.put("name", "hbase-regionserver");
        this.regionServerRegistration = context.registerService(ClusterActionHandler.class.getName(), (Object)this.regionServerClusterActionHandler, (Dictionary)regionServerProps);
        Properties restServerProps = new Properties();
        restServerProps.put("name", "hbase-restserver");
        this.restServerRegistration = context.registerService(ClusterActionHandler.class.getName(), (Object)this.restServerClusterActionHandler, (Dictionary)restServerProps);
        Properties avroServerProps = new Properties();
        avroServerProps.put("name", "hbase-avroserver");
        this.avroServerRegistration = context.registerService(ClusterActionHandler.class.getName(), (Object)this.avroServerClusterActionHandler, (Dictionary)avroServerProps);
        Properties thriftServerProps = new Properties();
        thriftServerProps.put("name", "hbase-thriftserver");
        this.thriftServerRegistration = context.registerService(ClusterActionHandler.class.getName(), (Object)this.thriftServerClusterActionHandler, (Dictionary)thriftServerProps);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.masterRegistration != null) {
            this.masterRegistration.unregister();
        }
        if (this.regionServerRegistration != null) {
            this.regionServerRegistration.unregister();
        }
        if (this.restServerRegistration != null) {
            this.restServerRegistration.unregister();
        }
        if (this.avroServerRegistration != null) {
            this.avroServerRegistration.unregister();
        }
        if (this.thriftServerRegistration != null) {
            this.thriftServerRegistration.unregister();
        }
        if (this.functionLoader != null) {
            this.functionLoader.stop();
        }
    }
}

