/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hbase;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.velocity.app.VelocityEngine;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.FirewallManager;
import org.apache.whirr.service.hbase.HBaseClusterActionHandler;
import org.apache.whirr.service.hbase.HBaseConfigurationBuilder;
import org.apache.whirr.service.zookeeper.ZooKeeperCluster;
import org.apache.whirr.template.TemplateUtils;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class HBaseRegionServerClusterActionHandler
extends HBaseClusterActionHandler {
    public static final String ROLE = "hbase-regionserver";
    public static final int REGIONSERVER_PORT = 60020;
    public static final int REGIONSERVER_WEB_UI_PORT = 60030;

    public String getRole() {
        return ROLE;
    }

    protected void beforeBootstrap(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Configuration conf = this.getConfiguration(clusterSpec);
        HBaseRegionServerClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        HBaseRegionServerClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"configure_hostnames", (String[])new String[0]));
        HBaseRegionServerClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_tarball", (String[])new String[0]));
        HBaseRegionServerClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getInstallFunction(conf, "java", "install_openjdk"), (String[])new String[0]));
        String tarurl = HBaseRegionServerClusterActionHandler.prepareRemoteFileUrl((ClusterActionEvent)event, (String)this.getConfiguration(clusterSpec).getString("whirr.hbase.tarball.url"));
        HBaseRegionServerClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getInstallFunction(this.getConfiguration(clusterSpec)), (String[])new String[]{"-u", tarurl}));
    }

    protected void beforeConfigure(ClusterActionEvent event) throws IOException, InterruptedException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        Configuration conf = this.getConfiguration(clusterSpec);
        Cluster.Instance instance = cluster.getInstanceMatching(RolePredicates.role((String)"hbase-master"));
        InetAddress masterPublicAddress = instance.getPublicAddress();
        event.getFirewallManager().addRules(new FirewallManager.Rule[]{FirewallManager.Rule.create().destination(instance).ports(new int[]{60030, 60020})});
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            event.getStatementBuilder().addStatements(new Statement[]{HBaseConfigurationBuilder.buildHBaseSite("/tmp/hbase-site.xml", clusterSpec, cluster), HBaseConfigurationBuilder.buildHBaseEnv("/tmp/hbase-env.sh", clusterSpec, cluster), TemplateUtils.createFileFromTemplate((String)"/tmp/hbase-hadoop-metrics.properties", (VelocityEngine)event.getTemplateEngine(), (String)this.getMetricsTemplate(event, clusterSpec, cluster), (ClusterSpec)clusterSpec, (Cluster)cluster)});
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTccl);
        }
        String master = masterPublicAddress.getHostName();
        String quorum = ZooKeeperCluster.getHosts((Cluster)cluster);
        String tarurl = HBaseRegionServerClusterActionHandler.prepareRemoteFileUrl((ClusterActionEvent)event, (String)conf.getString("whirr.hbase.tarball.url"));
        HBaseRegionServerClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        HBaseRegionServerClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getConfigureFunction(conf), (String[])new String[]{ROLE, "-m", master, "-q", quorum, "-u", tarurl}));
    }
}

