/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hbase;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.velocity.app.VelocityEngine;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.FirewallManager;
import org.apache.whirr.service.hadoop.HadoopProxy;
import org.apache.whirr.service.hbase.HBaseCluster;
import org.apache.whirr.service.hbase.HBaseClusterActionHandler;
import org.apache.whirr.service.hbase.HBaseConfigurationBuilder;
import org.apache.whirr.service.zookeeper.ZooKeeperCluster;
import org.apache.whirr.template.TemplateUtils;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseMasterClusterActionHandler
extends HBaseClusterActionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseMasterClusterActionHandler.class);
    public static final String ROLE = "hbase-master";
    public static final int MASTER_PORT = 60000;
    public static final int MASTER_WEB_UI_PORT = 60010;

    public String getRole() {
        return ROLE;
    }

    protected void beforeBootstrap(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Configuration conf = this.getConfiguration(clusterSpec);
        HBaseMasterClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        HBaseMasterClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_tarball", (String[])new String[0]));
        HBaseMasterClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"configure_hostnames", (String[])new String[0]));
        HBaseMasterClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getInstallFunction(conf, "java", "install_openjdk"), (String[])new String[0]));
        String tarurl = HBaseMasterClusterActionHandler.prepareRemoteFileUrl((ClusterActionEvent)event, (String)this.getConfiguration(clusterSpec).getString("whirr.hbase.tarball.url"));
        HBaseMasterClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getInstallFunction(this.getConfiguration(clusterSpec)), (String[])new String[]{"-u", tarurl}));
    }

    protected void beforeConfigure(ClusterActionEvent event) throws IOException, InterruptedException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        Configuration conf = this.getConfiguration(clusterSpec);
        LOG.info("Authorizing firewall");
        Cluster.Instance instance = cluster.getInstanceMatching(RolePredicates.role((String)ROLE));
        InetAddress masterPublicAddress = instance.getPublicAddress();
        event.getFirewallManager().addRules(new FirewallManager.Rule[]{FirewallManager.Rule.create().destination(instance).ports(new int[]{60010, 60000})});
        ClassLoader oldTccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            event.getStatementBuilder().addStatements(new Statement[]{HBaseConfigurationBuilder.buildHBaseSite("/tmp/hbase-site.xml", clusterSpec, cluster), HBaseConfigurationBuilder.buildHBaseEnv("/tmp/hbase-env.sh", clusterSpec, cluster), TemplateUtils.createFileFromTemplate((String)"/tmp/hbase-hadoop-metrics.properties", (VelocityEngine)event.getTemplateEngine(), (String)this.getMetricsTemplate(event, clusterSpec, cluster), (ClusterSpec)clusterSpec, (Cluster)cluster)});
        }
        catch (ConfigurationException e) {
            throw new IOException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTccl);
        }
        String master = masterPublicAddress.getHostName();
        String quorum = ZooKeeperCluster.getHosts((Cluster)cluster);
        String tarurl = HBaseMasterClusterActionHandler.prepareRemoteFileUrl((ClusterActionEvent)event, (String)conf.getString("whirr.hbase.tarball.url"));
        HBaseMasterClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        HBaseMasterClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getConfigureFunction(conf), (String[])new String[]{ROLE, "-m", master, "-q", quorum, "-u", tarurl}));
    }

    protected void afterConfigure(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        LOG.info("Completed configuration of {}", (Object)clusterSpec.getClusterName());
        Cluster.Instance instance = cluster.getInstanceMatching(RolePredicates.role((String)ROLE));
        InetAddress masterPublicAddress = instance.getPublicAddress();
        LOG.info("Web UI available at http://{}", (Object)masterPublicAddress.getHostName());
        String quorum = ZooKeeperCluster.getHosts((Cluster)cluster);
        Properties config = this.createClientSideProperties(masterPublicAddress, quorum);
        this.createClientSideHadoopSiteFile(clusterSpec, config);
        this.createProxyScript(clusterSpec, cluster);
        event.setCluster(new Cluster(cluster.getInstances(), config));
    }

    private Properties createClientSideProperties(InetAddress master, String quorum) throws IOException {
        Properties config = new Properties();
        config.setProperty("hbase.zookeeper.quorum", quorum);
        config.setProperty("hbase.zookeeper.property.clientPort", "2181");
        config.setProperty("hadoop.socks.server", "localhost:6666");
        config.setProperty("hadoop.rpc.socket.factory.class.default", "org.apache.hadoop.net.SocksSocketFactory");
        return config;
    }

    private void createClientSideHadoopSiteFile(ClusterSpec clusterSpec, Properties config) {
        File configDir = this.getConfigDir(clusterSpec);
        File hbaseSiteFile = new File(configDir, "hbase-site.xml");
        try {
            Files.write((CharSequence)this.generateHBaseConfigurationFile(config), (File)hbaseSiteFile, (Charset)Charsets.UTF_8);
            LOG.info("Wrote HBase site file {}", (Object)hbaseSiteFile);
        }
        catch (IOException e) {
            LOG.error("Problem writing HBase site file {}", (Object)hbaseSiteFile, (Object)e);
        }
    }

    private File getConfigDir(ClusterSpec clusterSpec) {
        File configDir = new File(new File(System.getProperty("user.home")), ".whirr");
        configDir = new File(configDir, clusterSpec.getClusterName());
        configDir.mkdirs();
        return configDir;
    }

    private CharSequence generateHBaseConfigurationFile(Properties config) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?>\n");
        sb.append("<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>\n");
        sb.append("<configuration>\n");
        for (Map.Entry<Object, Object> entry : config.entrySet()) {
            sb.append("  <property>\n");
            sb.append("    <name>").append(entry.getKey()).append("</name>\n");
            sb.append("    <value>").append(entry.getValue()).append("</value>\n");
            sb.append("  </property>\n");
        }
        sb.append("</configuration>\n");
        return sb;
    }

    private void createProxyScript(ClusterSpec clusterSpec, Cluster cluster) {
        File configDir = this.getConfigDir(clusterSpec);
        File hbaseProxyFile = new File(configDir, "hbase-proxy.sh");
        try {
            HadoopProxy proxy = new HadoopProxy(clusterSpec, cluster);
            InetAddress master = HBaseCluster.getMasterPublicAddress(cluster);
            String script = String.format("echo 'Running proxy to HBase cluster at %s. Use Ctrl-c to quit.'\n", master.getHostName()) + Joiner.on((String)" ").join((Object[])proxy.getProxyCommand());
            Files.write((CharSequence)script, (File)hbaseProxyFile, (Charset)Charsets.UTF_8);
            hbaseProxyFile.setExecutable(true);
            LOG.info("Wrote HBase proxy script {}", (Object)hbaseProxyFile);
        }
        catch (IOException e) {
            LOG.error("Problem writing HBase proxy script {}", (Object)hbaseProxyFile, (Object)e);
        }
    }
}

