/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hbase;

import java.io.IOException;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.hadoop.HadoopConfigurationConverter;
import org.apache.whirr.service.zookeeper.ZooKeeperCluster;
import org.jclouds.scriptbuilder.domain.Statement;

public class HBaseConfigurationBuilder {
    public static Statement buildHBaseSite(String path, ClusterSpec clusterSpec, Cluster cluster) throws ConfigurationException, IOException {
        Configuration config = HBaseConfigurationBuilder.buildHBaseSiteConfiguration(clusterSpec, cluster, (Configuration)new PropertiesConfiguration(HBaseConfigurationBuilder.class.getResource("/whirr-hbase-default.properties")));
        return HadoopConfigurationConverter.asCreateXmlConfigurationFileStatement((String)path, (Configuration)config);
    }

    static Configuration buildHBaseSiteConfiguration(ClusterSpec clusterSpec, Cluster cluster, Configuration defaults) throws ConfigurationException, IOException {
        Configuration config = HBaseConfigurationBuilder.build(clusterSpec, cluster, defaults, "hbase-site");
        Cluster.Instance master = cluster.getInstanceMatching(RolePredicates.role((String)"hbase-master"));
        String masterHostName = master.getPublicHostName();
        config.setProperty("hbase.rootdir", (Object)String.format("hdfs://%s:8020/hbase", masterHostName));
        config.setProperty("hbase.zookeeper.quorum", (Object)ZooKeeperCluster.getHosts((Cluster)cluster));
        return config;
    }

    public static Statement buildHBaseEnv(String path, ClusterSpec clusterSpec, Cluster cluster) throws ConfigurationException, IOException {
        Configuration config = HBaseConfigurationBuilder.buildHBaseEnvConfiguration(clusterSpec, cluster, (Configuration)new PropertiesConfiguration(HBaseConfigurationBuilder.class.getResource("/whirr-hbase-default.properties")));
        return HadoopConfigurationConverter.asCreateEnvironmentVariablesFileStatement((String)path, (Configuration)config);
    }

    static Configuration buildHBaseEnvConfiguration(ClusterSpec clusterSpec, Cluster cluster, Configuration defaults) throws ConfigurationException, IOException {
        Configuration config = HBaseConfigurationBuilder.build(clusterSpec, cluster, defaults, "hbase-env");
        return config;
    }

    private static Configuration build(ClusterSpec clusterSpec, Cluster cluster, Configuration defaults, String prefix) throws ConfigurationException {
        CompositeConfiguration config = new CompositeConfiguration();
        Configuration sub = clusterSpec.getConfigurationForKeysWithPrefix(prefix);
        config.addConfiguration(sub.subset(prefix));
        config.addConfiguration(defaults.subset(prefix));
        return config;
    }
}

