/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hbase;

import java.io.IOException;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.ClusterActionHandlerSupport;

public abstract class HBaseClusterActionHandler
extends ClusterActionHandlerSupport {
    protected synchronized Configuration getConfiguration(ClusterSpec clusterSpec) throws IOException {
        return this.getConfiguration(clusterSpec, "whirr-hbase-default.properties");
    }

    protected String getInstallFunction(Configuration config) {
        return this.getInstallFunction(config, "hbase", "install_hbase");
    }

    protected String getConfigureFunction(Configuration config) {
        return this.getConfigureFunction(config, "hbase", "configure_hbase");
    }

    protected String getMetricsTemplate(ClusterActionEvent event, ClusterSpec clusterSpec, Cluster cluster) {
        Configuration conf = clusterSpec.getConfiguration();
        if (conf.containsKey("hbase-metrics.template")) {
            return conf.getString("hbase-metrics.template");
        }
        Set gmetadInstances = cluster.getInstancesMatching(RolePredicates.role((String)"ganglia-metad"));
        if (!gmetadInstances.isEmpty()) {
            return "hbase-metrics-ganglia.properties.vm";
        }
        return "hbase-metrics-null.properties.vm";
    }
}

