/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hbase;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.configuration.Configuration;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.RolePredicates;
import org.apache.whirr.service.ClusterActionEvent;
import org.apache.whirr.service.FirewallManager;
import org.apache.whirr.service.hbase.HBaseClusterActionHandler;
import org.apache.whirr.service.zookeeper.ZooKeeperCluster;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class BasicServerClusterActionHandler
extends HBaseClusterActionHandler {
    private final String role;
    private final int defaultPort;
    private final String configKeyPort;

    public BasicServerClusterActionHandler(String role, int port, String configKeyPort) {
        this.role = role;
        this.defaultPort = port;
        this.configKeyPort = configKeyPort;
    }

    public String getRole() {
        return this.role;
    }

    protected void beforeBootstrap(ClusterActionEvent event) throws IOException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Configuration conf = this.getConfiguration(clusterSpec);
        BasicServerClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        BasicServerClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"configure_hostnames", (String[])new String[0]));
        BasicServerClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"install_tarball", (String[])new String[0]));
        BasicServerClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getInstallFunction(conf, "java", "install_openjdk"), (String[])new String[0]));
        String tarurl = BasicServerClusterActionHandler.prepareRemoteFileUrl((ClusterActionEvent)event, (String)conf.getString("whirr.hbase.tarball.url"));
        BasicServerClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getInstallFunction(conf), (String[])new String[]{"-u", tarurl}));
    }

    protected void beforeConfigure(ClusterActionEvent event) throws IOException, InterruptedException {
        ClusterSpec clusterSpec = event.getClusterSpec();
        Cluster cluster = event.getCluster();
        int port = this.defaultPort;
        if (this.configKeyPort != null) {
            port = this.getConfiguration(clusterSpec).getInt(this.configKeyPort, this.defaultPort);
        }
        Cluster.Instance instance = cluster.getInstanceMatching(RolePredicates.role((String)this.role));
        InetAddress masterPublicAddress = instance.getPublicAddress();
        event.getFirewallManager().addRule(FirewallManager.Rule.create().destination(instance).port(port));
        String master = masterPublicAddress.getHostName();
        String quorum = ZooKeeperCluster.getHosts((Cluster)cluster);
        String tarurl = BasicServerClusterActionHandler.prepareRemoteFileUrl((ClusterActionEvent)event, (String)this.getConfiguration(clusterSpec).getString("whirr.hbase.tarball.url"));
        BasicServerClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)"retry_helpers", (String[])new String[0]));
        BasicServerClusterActionHandler.addStatement((ClusterActionEvent)event, (Statement)Statements.call((String)this.getConfigureFunction(this.getConfiguration(clusterSpec)), (String[])new String[]{this.role, "-m", master, "-q", quorum, "-p", Integer.toString(port), "-u", tarurl}));
    }
}

