/*
 * Decompiled with CFR 0.152.
 */
package org.apache.whirr.service.hama.integration;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.hama.HamaConfiguration;
import org.apache.hama.bsp.BSPJobClient;
import org.apache.hama.bsp.ClusterStatus;
import org.apache.whirr.Cluster;
import org.apache.whirr.ClusterController;
import org.apache.whirr.ClusterSpec;
import org.apache.whirr.service.hadoop.HadoopProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HamaServiceController {
    private static final Logger LOG = LoggerFactory.getLogger(HamaServiceController.class);
    private static final HamaServiceController INSTANCE = new HamaServiceController();
    private boolean running;
    private ClusterSpec clusterSpec;
    private ClusterController controller;
    private HadoopProxy proxy;
    private Cluster cluster;

    public static HamaServiceController getInstance() {
        return INSTANCE;
    }

    private HamaServiceController() {
    }

    public synchronized boolean ensureClusterRunning() throws Exception {
        if (this.running) {
            LOG.info("Cluster already running.");
            return false;
        }
        this.startup();
        return true;
    }

    public synchronized void startup() throws Exception {
        LOG.info("Starting up cluster...");
        CompositeConfiguration config = new CompositeConfiguration();
        if (System.getProperty("config") != null) {
            config.addConfiguration((Configuration)new PropertiesConfiguration(System.getProperty("config")));
        }
        config.addConfiguration((Configuration)new PropertiesConfiguration(HamaServiceController.class.getResource("/whirr-hama-test.properties")));
        this.clusterSpec = ClusterSpec.withTemporaryKeys((Configuration)config);
        this.controller = new ClusterController();
        this.cluster = this.controller.launchCluster(this.clusterSpec);
        this.proxy = new HadoopProxy(this.clusterSpec, this.cluster);
        this.proxy.start();
        HamaConfiguration conf = this.getConfiguration();
        BSPJobClient client = new BSPJobClient((org.apache.hadoop.conf.Configuration)conf);
        HamaServiceController.waitForGroomServers(client);
        this.running = true;
    }

    private static void waitForGroomServers(BSPJobClient client) throws IOException {
        block3: {
            ClusterStatus clusterStatus;
            int grooms;
            do {
                try {
                    System.out.print(".");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    break block3;
                }
            } while ((grooms = (clusterStatus = client.getClusterStatus(true)).getActiveGroomServerStatus().size()) <= 0);
            LOG.info("{} groomservers reported in. Continuing.", (Object)grooms);
        }
    }

    public HamaConfiguration getConfiguration() {
        HamaConfiguration conf = new HamaConfiguration();
        for (Map.Entry<Object, Object> entry : this.cluster.getConfiguration().entrySet()) {
            conf.set(entry.getKey().toString(), entry.getValue().toString());
        }
        return conf;
    }

    public synchronized void shutdown() throws IOException, InterruptedException {
        LOG.info("Shutting down cluster...");
        if (this.proxy != null) {
            this.proxy.stop();
        }
        if (this.controller != null) {
            this.controller.destroyCluster(this.clusterSpec);
        }
        this.running = false;
    }
}

